/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.graph;

import java.awt.Graphics2D;
import java.awt.geom.Dimension2D;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.SpriteContainerEmpty;
import net.sourceforge.plantuml.cucadiagram.IEntity;
import net.sourceforge.plantuml.graph.AbstractEntityImage;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.HtmlColorUtils;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.skin.CircleInterface;
import net.sourceforge.plantuml.ugraphic.ColorMapper;

class EntityImageCircleInterface
extends AbstractEntityImage {
    private final TextBlock name;
    private final CircleInterface circleInterface;

    public EntityImageCircleInterface(IEntity entity) {
        super(entity);
        this.name = entity.getDisplay().create(new FontConfiguration(this.getFont14(), HtmlColorUtils.BLACK, HtmlColorUtils.BLUE, true), HorizontalAlignment.CENTER, new SpriteContainerEmpty());
        this.circleInterface = new CircleInterface(this.getYellow(), this.getRed());
    }

    @Override
    public Dimension2D getDimension(StringBounder stringBounder) {
        Dimension2D nameDim = this.name.calculateDimension(stringBounder);
        double manWidth = this.circleInterface.getPreferredWidth(stringBounder);
        double manHeight = this.circleInterface.getPreferredHeight(stringBounder);
        return new Dimension2DDouble(Math.max(manWidth, nameDim.getWidth()), manHeight + nameDim.getHeight());
    }

    @Override
    public void draw(ColorMapper colorMapper, Graphics2D g2d) {
        throw new UnsupportedOperationException();
    }
}

