/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.graph;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Dimension2D;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.SpriteContainerEmpty;
import net.sourceforge.plantuml.cucadiagram.IEntity;
import net.sourceforge.plantuml.graph.AbstractEntityImage;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.HtmlColorUtils;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.StringBounderUtils;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.ugraphic.ColorMapper;

class EntityImageDefault
extends AbstractEntityImage {
    private final TextBlock textBlock;

    public EntityImageDefault(IEntity entity) {
        super(entity);
        this.textBlock = entity.getDisplay().create(new FontConfiguration(this.getFont14(), HtmlColorUtils.BLACK, HtmlColorUtils.BLUE, true), HorizontalAlignment.CENTER, new SpriteContainerEmpty());
    }

    @Override
    public Dimension2D getDimension(StringBounder stringBounder) {
        Dimension2D dim = this.textBlock.calculateDimension(stringBounder);
        return new Dimension2DDouble(dim.getWidth(), dim.getHeight());
    }

    @Override
    public void draw(ColorMapper colorMapper, Graphics2D g2d) {
        Dimension2D dim = this.textBlock.calculateDimension(StringBounderUtils.asStringBounder(g2d));
        int width = (int)dim.getWidth();
        int height = (int)dim.getHeight();
        g2d.setColor(Color.BLACK);
        g2d.drawRect(0, 0, width, height);
    }
}

