/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.graph2;

import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import net.sourceforge.plantuml.geom.Orientation;
import net.sourceforge.plantuml.graph2.Singularity2;

public class Neighborhood2 {
    private final double angle1;
    private final double angle2;
    private final Point2D.Double center;

    public Neighborhood2(Point2D.Double center) {
        this(center, 0.0, 0.0);
    }

    public boolean is360() {
        return this.angle1 == this.angle2;
    }

    public Neighborhood2(Point2D.Double center, double angle1, double angle2) {
        this.center = center;
        this.angle1 = angle1;
        this.angle2 = angle2;
    }

    public boolean equals(Object obj) {
        Neighborhood2 other = (Neighborhood2)obj;
        return this.angle1 == other.angle1 && this.angle2 == other.angle2 && this.center.equals(other.center);
    }

    public int hashCode() {
        return this.center.hashCode() * 17 + new Point2D.Double(this.angle1, this.angle2).hashCode();
    }

    public String toString() {
        int a1 = (int)(this.angle1 * 180.0 / Math.PI);
        int a2 = (int)(this.angle2 * 180.0 / Math.PI);
        return this.center + " " + a1 + " " + a2;
    }

    public final Point2D.Double getCenter() {
        return this.center;
    }

    public Point2D.Double getPointInNeighborhood(double dist, Point2D p1, Point2D p2) {
        if (p1 == null || p2 == null) {
            throw new IllegalArgumentException();
        }
        if (dist <= 0.0) {
            throw new IllegalArgumentException();
        }
        double v1 = Singularity2.convertAngle(Singularity2.getAngle(new Line2D.Double(this.center, p1)) - this.angle1);
        double v2 = Singularity2.convertAngle(Singularity2.getAngle(new Line2D.Double(this.center, p2)) - this.angle1);
        if (v1 < 0.0) {
            throw new IllegalStateException();
        }
        if (v2 < 0.0) {
            throw new IllegalStateException();
        }
        double middle = (v1 + v2) / 2.0 + this.angle1;
        return new Point2D.Double(this.center.x + dist * Math.cos(middle), this.center.y + dist * Math.sin(middle));
    }

    public boolean isInAngleStrict(double angle) {
        if (angle < 0.0) {
            throw new IllegalArgumentException();
        }
        if (this.angle2 > this.angle1) {
            return angle > this.angle1 && angle < this.angle2;
        }
        return angle > this.angle1 || angle < this.angle2;
    }

    public boolean isInAngleLarge(double angle) {
        if (angle < 0.0) {
            throw new IllegalArgumentException();
        }
        if (this.angle2 > this.angle1) {
            return angle >= this.angle1 && angle <= this.angle2;
        }
        return angle >= this.angle1 || angle <= this.angle2;
    }

    public boolean isAngleLimit(double angle) {
        return angle == this.angle1 || angle == this.angle2;
    }

    public Orientation getOrientationFrom(double angle) {
        if (this.angle1 == this.angle2) {
            throw new IllegalStateException();
        }
        if (angle != this.angle1 && angle != this.angle2) {
            throw new IllegalArgumentException("this=" + this + " angle=" + (int)(angle * 180.0 / Math.PI));
        }
        assert (angle == this.angle1 || angle == this.angle2);
        if (angle == this.angle1) {
            return Orientation.MATH;
        }
        return Orientation.CLOCK;
    }

    public boolean isConnectable(Neighborhood2 other) {
        assert (this.isConnectableInternal(other) == other.isConnectableInternal(this));
        return this.isConnectableInternal(other);
    }

    private boolean isConnectableInternal(Neighborhood2 other) {
        if (this.getCenter().equals(other.getCenter())) {
            throw new IllegalArgumentException("Same center");
        }
        Line2D.Double seg1 = new Line2D.Double(this.getCenter(), other.getCenter());
        double angle1 = Singularity2.convertAngle(Singularity2.getAngle(seg1));
        double angle2 = Singularity2.convertAngle(Singularity2.getOppositeAngle(seg1));
        assert (angle2 == Singularity2.convertAngle(Singularity2.getAngle(new Line2D.Double(other.getCenter(), this.getCenter()))));
        if (this.isInAngleStrict(angle1) && other.isInAngleStrict(angle2)) {
            return true;
        }
        if (this.isInAngleStrict(angle1) && other.isInAngleLarge(angle2)) {
            return true;
        }
        if (this.isInAngleLarge(angle1) && other.isInAngleStrict(angle2)) {
            return true;
        }
        if (this.isAngleLimit(angle1) && other.isAngleLimit(angle2)) {
            Orientation o2;
            if (this.is360() || other.is360()) {
                return true;
            }
            Orientation o1 = this.getOrientationFrom(angle1);
            return o1 != (o2 = other.getOrientationFrom(angle2));
        }
        return false;
    }
}

