/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.postit;

import java.awt.geom.Dimension2D;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.FontParam;
import net.sourceforge.plantuml.SkinParam;
import net.sourceforge.plantuml.SpriteContainerEmpty;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.HtmlColorSetSimple;
import net.sourceforge.plantuml.graphic.HtmlColorUtils;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.SymbolContext;
import net.sourceforge.plantuml.skin.Area;
import net.sourceforge.plantuml.skin.Component;
import net.sourceforge.plantuml.skin.SimpleContext2D;
import net.sourceforge.plantuml.skin.rose.ComponentRoseNote;
import net.sourceforge.plantuml.ugraphic.UFont;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UStroke;

public class PostIt {
    private final String id;
    private final Display text;
    private Dimension2D minimunDimension;

    public PostIt(String id, Display text) {
        this.id = id;
        this.text = text;
    }

    public String getId() {
        return this.id;
    }

    public Display getText() {
        return this.text;
    }

    public Dimension2D getMinimunDimension() {
        return this.minimunDimension;
    }

    public void setMinimunDimension(Dimension2D minimunDimension) {
        this.minimunDimension = minimunDimension;
    }

    public Dimension2D getDimension(StringBounder stringBounder) {
        double width = this.getComponent().getPreferredWidth(stringBounder);
        double height = this.getComponent().getPreferredHeight(stringBounder);
        if (this.minimunDimension != null && width < this.minimunDimension.getWidth()) {
            width = this.minimunDimension.getWidth();
        }
        if (this.minimunDimension != null && height < this.minimunDimension.getHeight()) {
            height = this.minimunDimension.getHeight();
        }
        return new Dimension2DDouble(width, height);
    }

    public void drawU(UGraphic ug) {
        Component note = this.getComponent();
        StringBounder stringBounder = ug.getStringBounder();
        Dimension2D dimensionToUse = this.getDimension(stringBounder);
        note.drawU(ug, new Area(dimensionToUse), new SimpleContext2D(false));
    }

    private Component getComponent() {
        HtmlColor noteBackgroundColor = new HtmlColorSetSimple().getColorIfValid("#FBFB77");
        HtmlColor borderColor = HtmlColorUtils.MY_RED;
        SkinParam param = SkinParam.noShadowing();
        UFont fontNote = param.getFont(FontParam.NOTE, null, false);
        ComponentRoseNote note = new ComponentRoseNote(new SymbolContext(noteBackgroundColor, borderColor).withStroke(new UStroke()), fontNote.toFont2(HtmlColorUtils.BLACK, true, HtmlColorUtils.BLUE), this.text, 0.0, 0.0, new SpriteContainerEmpty());
        return note;
    }
}

