/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.statediagram.command;

import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.SingleLineCommand2;
import net.sourceforge.plantuml.command.regex.RegexConcat;
import net.sourceforge.plantuml.command.regex.RegexLeaf;
import net.sourceforge.plantuml.command.regex.RegexOr;
import net.sourceforge.plantuml.command.regex.RegexResult;
import net.sourceforge.plantuml.cucadiagram.Code;
import net.sourceforge.plantuml.cucadiagram.IEntity;
import net.sourceforge.plantuml.statediagram.StateDiagram;

public class CommandAddField
extends SingleLineCommand2<StateDiagram> {
    public CommandAddField() {
        super(CommandAddField.getRegexConcat());
    }

    private static RegexConcat getRegexConcat() {
        return new RegexConcat(new RegexLeaf("^"), new RegexOr(new RegexLeaf("CODE3", "([\\p{L}0-9_.]+)"), new RegexLeaf("CODE4", "[%g]([^%g]+)[%g]")), new RegexLeaf("[%s]*:[%s]*"), new RegexLeaf("FIELD", "(.*)"), new RegexLeaf("$"));
    }

    @Override
    protected CommandExecutionResult executeArg(StateDiagram diagram, RegexResult arg) {
        String code = arg.getLazzy("CODE", 0);
        String field = arg.get("FIELD", 0);
        IEntity entity = diagram.getOrCreateLeaf(Code.of(code), null, null);
        entity.getBodier().addFieldOrMethod(field);
        return CommandExecutionResult.ok();
    }
}

