// Copyright 2023-2024 Buf Technologies, Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-connect-go. DO NOT EDIT.
//
// Source: buf/registry/module/v1beta1/commit_service.proto

package modulev1beta1connect

import (
	v1beta1 "buf.build/gen/go/bufbuild/registry/protocolbuffers/go/buf/registry/module/v1beta1"
	connect "connectrpc.com/connect"
	context "context"
	errors "errors"
	http "net/http"
	strings "strings"
)

// This is a compile-time assertion to ensure that this generated file and the connect package are
// compatible. If you get a compiler error that this constant is not defined, this code was
// generated with a version of connect newer than the one compiled into your binary. You can fix the
// problem by either regenerating this code with an older version of connect or updating the connect
// version compiled into your binary.
const _ = connect.IsAtLeastVersion1_13_0

const (
	// CommitServiceName is the fully-qualified name of the CommitService service.
	CommitServiceName = "buf.registry.module.v1beta1.CommitService"
)

// These constants are the fully-qualified names of the RPCs defined in this package. They're
// exposed at runtime as Spec.Procedure and as the final two segments of the HTTP route.
//
// Note that these are different from the fully-qualified method names used by
// google.golang.org/protobuf/reflect/protoreflect. To convert from these constants to
// reflection-formatted method names, remove the leading slash and convert the remaining slash to a
// period.
const (
	// CommitServiceGetCommitsProcedure is the fully-qualified name of the CommitService's GetCommits
	// RPC.
	CommitServiceGetCommitsProcedure = "/buf.registry.module.v1beta1.CommitService/GetCommits"
	// CommitServiceListCommitsProcedure is the fully-qualified name of the CommitService's ListCommits
	// RPC.
	CommitServiceListCommitsProcedure = "/buf.registry.module.v1beta1.CommitService/ListCommits"
)

// These variables are the protoreflect.Descriptor objects for the RPCs defined in this package.
var (
	commitServiceServiceDescriptor           = v1beta1.File_buf_registry_module_v1beta1_commit_service_proto.Services().ByName("CommitService")
	commitServiceGetCommitsMethodDescriptor  = commitServiceServiceDescriptor.Methods().ByName("GetCommits")
	commitServiceListCommitsMethodDescriptor = commitServiceServiceDescriptor.Methods().ByName("ListCommits")
)

// CommitServiceClient is a client for the buf.registry.module.v1beta1.CommitService service.
type CommitServiceClient interface {
	// Get Commits.
	GetCommits(context.Context, *connect.Request[v1beta1.GetCommitsRequest]) (*connect.Response[v1beta1.GetCommitsResponse], error)
	// List Commits for a given Module, Label, or Commit.
	ListCommits(context.Context, *connect.Request[v1beta1.ListCommitsRequest]) (*connect.Response[v1beta1.ListCommitsResponse], error)
}

// NewCommitServiceClient constructs a client for the buf.registry.module.v1beta1.CommitService
// service. By default, it uses the Connect protocol with the binary Protobuf Codec, asks for
// gzipped responses, and sends uncompressed requests. To use the gRPC or gRPC-Web protocols, supply
// the connect.WithGRPC() or connect.WithGRPCWeb() options.
//
// The URL supplied here should be the base URL for the Connect or gRPC server (for example,
// http://api.acme.com or https://acme.com/grpc).
func NewCommitServiceClient(httpClient connect.HTTPClient, baseURL string, opts ...connect.ClientOption) CommitServiceClient {
	baseURL = strings.TrimRight(baseURL, "/")
	return &commitServiceClient{
		getCommits: connect.NewClient[v1beta1.GetCommitsRequest, v1beta1.GetCommitsResponse](
			httpClient,
			baseURL+CommitServiceGetCommitsProcedure,
			connect.WithSchema(commitServiceGetCommitsMethodDescriptor),
			connect.WithIdempotency(connect.IdempotencyNoSideEffects),
			connect.WithClientOptions(opts...),
		),
		listCommits: connect.NewClient[v1beta1.ListCommitsRequest, v1beta1.ListCommitsResponse](
			httpClient,
			baseURL+CommitServiceListCommitsProcedure,
			connect.WithSchema(commitServiceListCommitsMethodDescriptor),
			connect.WithIdempotency(connect.IdempotencyNoSideEffects),
			connect.WithClientOptions(opts...),
		),
	}
}

// commitServiceClient implements CommitServiceClient.
type commitServiceClient struct {
	getCommits  *connect.Client[v1beta1.GetCommitsRequest, v1beta1.GetCommitsResponse]
	listCommits *connect.Client[v1beta1.ListCommitsRequest, v1beta1.ListCommitsResponse]
}

// GetCommits calls buf.registry.module.v1beta1.CommitService.GetCommits.
func (c *commitServiceClient) GetCommits(ctx context.Context, req *connect.Request[v1beta1.GetCommitsRequest]) (*connect.Response[v1beta1.GetCommitsResponse], error) {
	return c.getCommits.CallUnary(ctx, req)
}

// ListCommits calls buf.registry.module.v1beta1.CommitService.ListCommits.
func (c *commitServiceClient) ListCommits(ctx context.Context, req *connect.Request[v1beta1.ListCommitsRequest]) (*connect.Response[v1beta1.ListCommitsResponse], error) {
	return c.listCommits.CallUnary(ctx, req)
}

// CommitServiceHandler is an implementation of the buf.registry.module.v1beta1.CommitService
// service.
type CommitServiceHandler interface {
	// Get Commits.
	GetCommits(context.Context, *connect.Request[v1beta1.GetCommitsRequest]) (*connect.Response[v1beta1.GetCommitsResponse], error)
	// List Commits for a given Module, Label, or Commit.
	ListCommits(context.Context, *connect.Request[v1beta1.ListCommitsRequest]) (*connect.Response[v1beta1.ListCommitsResponse], error)
}

// NewCommitServiceHandler builds an HTTP handler from the service implementation. It returns the
// path on which to mount the handler and the handler itself.
//
// By default, handlers support the Connect, gRPC, and gRPC-Web protocols with the binary Protobuf
// and JSON codecs. They also support gzip compression.
func NewCommitServiceHandler(svc CommitServiceHandler, opts ...connect.HandlerOption) (string, http.Handler) {
	commitServiceGetCommitsHandler := connect.NewUnaryHandler(
		CommitServiceGetCommitsProcedure,
		svc.GetCommits,
		connect.WithSchema(commitServiceGetCommitsMethodDescriptor),
		connect.WithIdempotency(connect.IdempotencyNoSideEffects),
		connect.WithHandlerOptions(opts...),
	)
	commitServiceListCommitsHandler := connect.NewUnaryHandler(
		CommitServiceListCommitsProcedure,
		svc.ListCommits,
		connect.WithSchema(commitServiceListCommitsMethodDescriptor),
		connect.WithIdempotency(connect.IdempotencyNoSideEffects),
		connect.WithHandlerOptions(opts...),
	)
	return "/buf.registry.module.v1beta1.CommitService/", http.HandlerFunc(func(w http.ResponseWriter, r *http.Request) {
		switch r.URL.Path {
		case CommitServiceGetCommitsProcedure:
			commitServiceGetCommitsHandler.ServeHTTP(w, r)
		case CommitServiceListCommitsProcedure:
			commitServiceListCommitsHandler.ServeHTTP(w, r)
		default:
			http.NotFound(w, r)
		}
	})
}

// UnimplementedCommitServiceHandler returns CodeUnimplemented from all methods.
type UnimplementedCommitServiceHandler struct{}

func (UnimplementedCommitServiceHandler) GetCommits(context.Context, *connect.Request[v1beta1.GetCommitsRequest]) (*connect.Response[v1beta1.GetCommitsResponse], error) {
	return nil, connect.NewError(connect.CodeUnimplemented, errors.New("buf.registry.module.v1beta1.CommitService.GetCommits is not implemented"))
}

func (UnimplementedCommitServiceHandler) ListCommits(context.Context, *connect.Request[v1beta1.ListCommitsRequest]) (*connect.Response[v1beta1.ListCommitsResponse], error) {
	return nil, connect.NewError(connect.CodeUnimplemented, errors.New("buf.registry.module.v1beta1.CommitService.ListCommits is not implemented"))
}
