/* 
 * CREATIVE WEBCAM Notebook Image capture Program for NetBSD version.0.00-alpha
 * cnxtview - Sequential image capture program.
 * Copyright (C) 2004 Takafumi Mizuno <taka-qce@ls-a.jp>
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */
/*
 * Credits:
 * Special Thanks to Windows USb Sniffer Project developers.
 */

/*
 * Reference: Image Processing Program by Linux, author Iio Jun, ohmsha publishing
 *            ISBN:4-274-94623-1 ( Japanese Only! )
 */

#include <sys/ioctl.h>
#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#include <fcntl.h>
#include <unistd.h>
#include <errno.h>
#include <string.h>
#include <err.h>

#include <dev/usb/usb.h>

#include <gtk/gtk.h>
#include <gdk_imlib.h>

#include "gui.h"
#include "cnxt.h"

/* jpeg_decode.c */
unsigned char * jpeg_decode(unsigned char *srcptr,int srclen, int * dlen);
void end_jpeg(void);

static struct usb_dev_info mydevs [] = {
	{ "creative WEBCAM Notebook", 0x0572, 0x0041, 0},	/* Creative WEBCAM Notebook */
	{ NULL }						/* 0x0572=Conexant Systems, Inc.	*/
};

static char dev[FILENAME_MAX];
static char epdevname[FILENAME_MAX];
static int fd, efd;

u_int8_t isobuf[ISOBUF_SIZE];		/* one raw isoc packets data */

GdkImlibImage *get_new_frame(GdkImlibImage *);

int	errnum = 0;	/* shared gui.c */
int	vflag = 0;	/* shared gui.c */

int main(int argc, char *argv[])
{
    int i;
    int ret;
    
    fd = NULL;
    efd = NULL;

    gtk_init(&argc, &argv);
    gdk_imlib_init();

    /* check option */
    if (argc == 1) {
	for ( i = 0; i < 15; ++i ) {
#ifdef __NetBSD__
	    sprintf(dev, "/dev/ugen%d.00", i);
#else
	    sprintf(dev, "/dev/ugen%d", i);
#endif
	    if ( (fd = open(dev, O_RDWR)) < 0 ) {
		continue;
	    }
	    if ( usbdev_probe(fd, mydevs) != 0 ) {
		close(fd);
		fd = -1;
		continue;
	    } else {
		break;
	    }
	}
    } else {
	if ( argv[1][0] != '/' ) {
	    fprintf(stderr, "usage: %s [device-name]\n", argv[0]);
	    fprintf(stderr, "    [device-name] must be started slash \'/\' character.\n");
	    exit(1);
	}
	strncpy(dev, argv[1], FILENAME_MAX-1);
	if ( (fd = open(dev, O_RDWR)) < 0 ) {
	    err(1, "%s", dev);
	} else {
	    if ( usbdev_probe(fd, mydevs) != 0 ) {
		close(fd);
		fd = -1;
	    }
	}
    }

    if (fd < 0) {
	fprintf(stderr, "Not found USB camera, or Permission denied\n");
	return 1;
    }

    /* init */
    ret = -1;
    if ( camera_init(fd) < 0 ) goto BYE;
    memset((void *)(picbuf+HEADER_SIZE), 0, (WIDTH*HEIGHT*3)-HEADER_SIZE);
    fprintf(stderr, "camera_init success\n");

    /* open endpoint  */
#ifdef __NetBSD__
    sprintf(epdevname, "%s.01", strtok(dev,"."));
#else
    sprintf(epdevname, "%s.1", dev);
#endif
    if ((efd = open(epdevname, O_RDONLY)) < 0) {
	perror(epdevname);
	ret = 2;
	goto BYE;
    } 
    if ( (ret = camera_init2(fd)) != 0 ) {
	ret = 2;
	goto EPOPENERR;
    }

    gui_config();
    gtk_main();

    fprintf(stderr, "Closing .....");
    end_jpeg();
    ret = 0;

EPOPENERR:
    close(efd);
    (void)usb_set_interface(fd, 0);

BYE:
    close(fd);
    fprintf(stderr, "Done.\n");

    return ret;
}

/*
 *
 */
GdkImlibImage *get_new_frame(GdkImlibImage *current)
{
    u_int32_t errcnt;
    int frame_ready;
    u_int8_t *cdata, *wdata, *imagedat = NULL;
    int imagelen;
    ssize_t grablen;
    ssize_t readlen; /* return value of read(2) */

    GdkImlibImage *im = NULL;

    if (current) gdk_imlib_kill_image(current);
    errcnt = 0;
    grablen = 0;
    cdata = isobuf;
    wdata = picbuf + HEADER_SIZE;
    frame_ready = 0;

    for (;;) {
	readlen = read(efd, (void *)cdata, ISOBUF_SIZE);
	if ( readlen < 0 ) {
	    perror("read");
	    errnum++;
	    return NULL;
	}
	if ( grablen + readlen > PICBUF_FREESIZE ) {
	    fprintf(stderr,"isoc read data overflow = %d\n", readlen);
	    return NULL;
	}
	if ( grablen == 0 ) {
	    /* search header */
	    if ((cdata[0] == 0xFF) && (cdata[1] == 0xD8)
		       && (cdata[2] == 0xFF)) {
		memcpy(wdata, &cdata[2], readlen-2);
		grablen = readlen-2;
	    } else {
		/* igonore data */
		continue;
	    }
	} else if ( readlen > 0 ) {
	    int i;
	    memcpy(wdata+grablen, cdata, readlen);
	    grablen += readlen;
	    for ( i = 0; i < readlen - 2; i++ ) {
		if ( (cdata[i+1] == 0xFF) && (cdata[i+2] == 0xD9)) {
		    if ( ( cdata[i] == 0x7F ) || ( cdata[i] == 0xFF )) {
			/* resize grablen */
			grablen -= readlen;
			grablen += (i+3);
			frame_ready = 1;
			break;
		    }
		}
	    }
	}
	if ( frame_ready != 0 ) break;
    }

    imagedat = jpeg_decode(picbuf, (int)(grablen+HEADER_SIZE), &imagelen);
    if ( (imagelen >= IMAGE_SIZE) && (imagedat != NULL) ) {
	im = gdk_imlib_create_image_from_data(imagedat, NULL,
					      WIDTH, HEIGHT);

	if (vflag) {
	    gdk_imlib_flip_image_horizontal(im);
	    gdk_imlib_flip_image_vertical(im);
	}
    }

    return im;
}

