/*
 * GUI of sequential image capture program.
 *    gui.[ch] GUI and callback functions
 *
 * Copyright (C) 2003,2004 Takafumi Mizuno <taka-qce@ls-a.jp>
 *
 * Reference: Image Processing Program by Linux, author Iio Jun, ohmsha publishing
 *            ISBN:4-274-94623-1 ( Japanese Only! )
 */
#include <gtk/gtk.h>
#include <gdk_imlib.h>

#include "gui.h"

/* cnxtview.c */
extern int	errnum;
extern int	vflag;

GdkImlibImage *get_new_frame(GdkImlibImage *);


/* micro seconds */
#define INTERVAL 50

/* display area */
static GdkImlibImage *im = NULL;

/* backing store pixmap area */
static GdkPixmap *pixmap = NULL;

/* interval timer tag */
static gint ttag;

/* set GUI */
void gui_config(void)
{
  int i;
  GtkWidget *main_window;
  GtkWidget *aspframe;
  GtkWidget *drawing_area;

  /* Top level Main Window */
  main_window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
  gtk_signal_connect(GTK_OBJECT(main_window), "destroy",
		     GTK_SIGNAL_FUNC(gtk_main_quit), NULL);

  /* aspect frame */
  aspframe = gtk_aspect_frame_new(NULL,0.5,0.5,1.0,TRUE);
  gtk_frame_set_shadow_type(GTK_FRAME(aspframe), GTK_SHADOW_NONE);

  for ( i = 0; i < 20; i++ ) im = get_new_frame(im);

  /* display area */
  drawing_area = gtk_drawing_area_new();
  gtk_drawing_area_size(GTK_DRAWING_AREA(drawing_area),
			im->rgb_width, im->rgb_height);
  gtk_container_add(GTK_CONTAINER(main_window), aspframe);
  gtk_container_add(GTK_CONTAINER(aspframe), drawing_area);

  /* signal configure */
  gtk_signal_connect(GTK_OBJECT(main_window), "destroy",
		     GTK_SIGNAL_FUNC(gtk_main_quit), NULL);
  gtk_signal_connect(GTK_OBJECT(drawing_area), "expose_event",
		     GTK_SIGNAL_FUNC(exposed), NULL);
  gtk_signal_connect(GTK_OBJECT(drawing_area), "configure_event",
		     GTK_SIGNAL_FUNC(configured), NULL);
  gtk_signal_connect(GTK_OBJECT(main_window), "key_press_event",
		     GTK_SIGNAL_FUNC(flipvertical), NULL);
  gtk_widget_set_events(drawing_area, GDK_EXPOSURE_MASK);

  /* timer set */
  ttag = gtk_timeout_add(INTERVAL, (GtkFunction)update_screen,
			 (gpointer)drawing_area);

  /* display */
  gtk_widget_show_all(main_window);
  return;
}

/* configure(e.g. resize) event */
gint configured(GtkWidget *widget, GdkEventConfigure *event)
{
    gint w, h;

    w = widget->allocation.width;
    h = widget->allocation.height;
    gdk_imlib_render(im, w, h);

    /* create new pixmap from new size image */
    if ( pixmap ) gdk_imlib_free_pixmap(pixmap);
    pixmap = gdk_imlib_move_image(im);

    return TRUE;
}

/* exposed event */
gint exposed(GtkWidget *widget, GdkEventExpose *event)
{
    if (pixmap) gdk_draw_pixmap(widget->window,
				widget->style->fg_gc[GTK_WIDGET_STATE(widget)],
				pixmap,
				event->area.x, event->area.y,
				event->area.x, event->area.y,
				event->area.width, event->area.height);
    return TRUE;
}

/* key_press event */
gint flipvertical(GtkWidget *widget, GdkEventExpose *event)
{
    vflag = (vflag + 1) & 0x01;
    return TRUE;
}

gint update_screen(GtkWidget *widget)
{
    GdkEventExpose e;

    if ( errnum > ERRNUM_LIMITS ) {
	gtk_main_quit();
	return FALSE;
    }

    e.type = GDK_EXPOSE;
    e.window = widget->window;
    e.area.x = 0; e.area.y = 0;
    e.area.width = widget->allocation.width;
    e.area.height = widget->allocation.height;
    e.send_event = 0; e.count = 0;

    if ( e.window != NULL ) {
	im = get_new_frame(im);
	if ( im == NULL ) {
	    /* do nothing */
	    return TRUE;
	}
	configured(widget, NULL);
	exposed(widget, &e);
    }

    return TRUE;

}
