#include "cnxt.h"

u_int8_t picbuf[WIDTH*HEIGHT*3] = {
0xff, 0xd8, 0xff, 0xdb, 0x00, 0x84, 0x00, 0x05, 
0x03, 0x04, 0x04, 0x04, 0x03, 0x05, 0x04, 0x04, 
0x04, 0x05, 0x05, 0x05, 0x06, 0x07, 0x0c, 0x08, 
0x07, 0x07, 0x07, 0x07, 0x0f, 0x0b, 0x0b, 0x09, 
0x0c, 0x11, 0x0f, 0x12, 0x12, 0x11, 0x0f, 0x11, 
0x11, 0x13, 0x16, 0x1c, 0x17, 0x13, 0x14, 0x1a, 
0x15, 0x11, 0x11, 0x18, 0x21, 0x18, 0x1a, 0x1d, 
0x1d, 0x1f, 0x1f, 0x1f, 0x13, 0x17, 0x22, 0x24, 
0x22, 0x1e, 0x24, 0x1c, 0x1e, 0x1f, 0x1e, 0x01, 
0x05, 0x03, 0x04, 0x04, 0x04, 0x03, 0x05, 0x04, 
0x04, 0x04, 0x05, 0x05, 0x05, 0x06, 0x07, 0x0c, 
0x08, 0x07, 0x07, 0x07, 0x07, 0x0f, 0x0b, 0x0b, 
0x09, 0x0c, 0x11, 0x0f, 0x12, 0x12, 0x11, 0x0f, 
0x11, 0x11, 0x13, 0x16, 0x1c, 0x17, 0x13, 0x14, 
0x1a, 0x15, 0x11, 0x11, 0x18, 0x21, 0x18, 0x1a, 
0x1d, 0x1d, 0x1f, 0x1f, 0x1f, 0x13, 0x17, 0x22, 
0x24, 0x22, 0x1e, 0x24, 0x1c, 0x1e, 0x1f, 0x1e, 
0xff, 0xc4, 0x01, 0xa2, 0x00, 0x00, 0x01, 0x05, 
0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x02, 
0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0a, 
0x0b, 0x01, 0x00, 0x03, 0x01, 0x01, 0x01, 0x01, 
0x01, 0x01, 0x01, 0x01, 0x01, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 
0x06, 0x07, 0x08, 0x09, 0x0a, 0x0b, 0x10, 0x00, 
0x02, 0x01, 0x03, 0x03, 0x02, 0x04, 0x03, 0x05, 
0x05, 0x04, 0x04, 0x00, 0x00, 0x01, 0x7d, 0x01, 
0x02, 0x03, 0x00, 0x04, 0x11, 0x05, 0x12, 0x21, 
0x31, 0x41, 0x06, 0x13, 0x51, 0x61, 0x07, 0x22, 
0x71, 0x14, 0x32, 0x81, 0x91, 0xa1, 0x08, 0x23, 
0x42, 0xb1, 0xc1, 0x15, 0x52, 0xd1, 0xf0, 0x24, 
0x33, 0x62, 0x72, 0x82, 0x09, 0x0a, 0x16, 0x17, 
0x18, 0x19, 0x1a, 0x25, 0x26, 0x27, 0x28, 0x29, 
0x2a, 0x34, 0x35, 0x36, 0x37, 0x38, 0x39, 0x3a, 
0x43, 0x44, 0x45, 0x46, 0x47, 0x48, 0x49, 0x4a, 
0x53, 0x54, 0x55, 0x56, 0x57, 0x58, 0x59, 0x5a, 
0x63, 0x64, 0x65, 0x66, 0x67, 0x68, 0x69, 0x6a, 
0x73, 0x74, 0x75, 0x76, 0x77, 0x78, 0x79, 0x7a, 
0x83, 0x84, 0x85, 0x86, 0x87, 0x88, 0x89, 0x8a, 
0x92, 0x93, 0x94, 0x95, 0x96, 0x97, 0x98, 0x99, 
0x9a, 0xa2, 0xa3, 0xa4, 0xa5, 0xa6, 0xa7, 0xa8, 
0xa9, 0xaa, 0xb2, 0xb3, 0xb4, 0xb5, 0xb6, 0xb7, 
0xb8, 0xb9, 0xba, 0xc2, 0xc3, 0xc4, 0xc5, 0xc6, 
0xc7, 0xc8, 0xc9, 0xca, 0xd2, 0xd3, 0xd4, 0xd5, 
0xd6, 0xd7, 0xd8, 0xd9, 0xda, 0xe1, 0xe2, 0xe3, 
0xe4, 0xe5, 0xe6, 0xe7, 0xe8, 0xe9, 0xea, 0xf1, 
0xf2, 0xf3, 0xf4, 0xf5, 0xf6, 0xf7, 0xf8, 0xf9, 
0xfa, 0x11, 0x00, 0x02, 0x01, 0x02, 0x04, 0x04, 
0x03, 0x04, 0x07, 0x05, 0x04, 0x04, 0x00, 0x01, 
0x02, 0x77, 0x00, 0x01, 0x02, 0x03, 0x11, 0x04, 
0x05, 0x21, 0x31, 0x06, 0x12, 0x41, 0x51, 0x07, 
0x61, 0x71, 0x13, 0x22, 0x32, 0x81, 0x08, 0x14, 
0x42, 0x91, 0xa1, 0xb1, 0xc1, 0x09, 0x23, 0x33, 
0x52, 0xf0, 0x15, 0x62, 0x72, 0xd1, 0x0a, 0x16, 
0x24, 0x34, 0xe1, 0x25, 0xf1, 0x17, 0x18, 0x19, 
0x1a, 0x26, 0x27, 0x28, 0x29, 0x2a, 0x35, 0x36, 
0x37, 0x38, 0x39, 0x3a, 0x43, 0x44, 0x45, 0x46, 
0x47, 0x48, 0x49, 0x4a, 0x53, 0x54, 0x55, 0x56, 
0x57, 0x58, 0x59, 0x5a, 0x63, 0x64, 0x65, 0x66, 
0x67, 0x68, 0x69, 0x6a, 0x73, 0x74, 0x75, 0x76, 
0x77, 0x78, 0x79, 0x7a, 0x82, 0x83, 0x84, 0x85, 
0x86, 0x87, 0x88, 0x89, 0x8a, 0x92, 0x93, 0x94, 
0x95, 0x96, 0x97, 0x98, 0x99, 0x9a, 0xa2, 0xa3, 
0xa4, 0xa5, 0xa6, 0xa7, 0xa8, 0xa9, 0xaa, 0xb2, 
0xb3, 0xb4, 0xb5, 0xb6, 0xb7, 0xb8, 0xb9, 0xba, 
0xc2, 0xc3, 0xc4, 0xc5, 0xc6, 0xc7, 0xc8, 0xc9, 
0xca, 0xd2, 0xd3, 0xd4, 0xd5, 0xd6, 0xd7, 0xd8, 
0xd9, 0xda, 0xe2, 0xe3, 0xe4, 0xe5, 0xe6, 0xe7, 
0xe8, 0xe9, 0xea, 0xf2, 0xf3, 0xf4, 0xf5, 0xf6, 
0xf7, 0xf8, 0xf9, 0xfa,
};


int ignoreURB[] = { 27, -1 };

/*
 * init #1 coloer space i420 320x240
 */
initURB_t i420_init1[INIT1_URBS_NUM] = {
	{ ACT_WRITE, 0x0010, 0x0001, { 0x00 } }, /*   5 */ /* [0] */
	{ ACT_WRITE, 0x0053, 0x0001, { 0x00 } }, /*   6 */ /* [1] */
	{ ACT_WRITE, 0x0032, 0x0001, { 0x00 } }, /*   7 */ /* [2] */
	{ ACT_WRITE, 0x009b, 0x0001, { 0x2f } }, /*   8 */ /* [3] */
	{ ACT_WRITE, 0x009c, 0x0001, { 0x10 } }, /*   9 */ /* [4] */
	{  ACT_READ, 0x0098, 0x0001, { 0x00 } }, /*  10 */ /* [5] */
	{ ACT_WRITE, 0x0098, 0x0001, { 0x40 } }, /*  11 */ /* [6] */
	{  ACT_READ, 0x0099, 0x0001, { 0x00 } }, /*  12 */ /* [7] */
	{ ACT_WRITE, 0x0099, 0x0001, { 0x07 } }, /*  13 */ /* [8] */
	{ ACT_WRITE, 0x0039, 0x0001, { 0x40 } }, /*  14 */ /* [9] */
	{ ACT_WRITE, 0x003c, 0x0001, { 0xff } }, /*  15 */ /* [10] */
	{ ACT_WRITE, 0x003f, 0x0001, { 0x1f } }, /*  16 */ /* [11] */
	{ ACT_WRITE, 0x003d, 0x0001, { 0x40 } }, /*  17 */ /* [12] */
	{ ACT_WRITE, 0x003d, 0x0001, { 0x60 } }, /*  18 */ /* [13] */
	{  ACT_READ, 0x0099, 0x0001, { 0x07 } }, /*  19 */ /* [14] */
	{ ACT_WRITE, 0x00e5, 0x0004, { 0x88, 0x11, 0x01, 0x01 } }, /*  20 */ /* [15] */
	{  ACT_READ, 0x00e8, 0x0001, { 0x00 } }, /*  21 */ /* [16] */
	{ ACT_WRITE, 0x00e5, 0x0004, { 0x88, 0x12, 0x70, 0x01 } }, /*  22 */ /* [17] */
	{  ACT_READ, 0x00e8, 0x0001, { 0x00 } }, /*  23 */ /* [18] */
	{ ACT_WRITE, 0x00ed, 0x0001, { 0x01 } }, /*  24 */ /* [19] */
	{  ACT_READ, 0x00ed, 0x0001, { 0x01 } }, /*  25 */ /* [20] */
	{ ACT_WRITE, 0x00e5, 0x0004, { 0x88, 0x0f, 0x00, 0x01 } }, /*  26 */ /* [21] */
	{  ACT_READ, 0x00e8, 0x0001, { 0x00 } }, /*  27 */ /* [22] */
	{ ACT_WRITE, 0x00e5, 0x0004, { 0x88, 0x05, 0x01, 0x01 } }, /*  28 */ /* [23] */
	{  ACT_READ, 0x00e8, 0x0001, { 0x00 } }, /*  29 */ /* [24] */
	{ ACT_WRITE, 0x00c3, 0x0001, { 0x00 } }, /*  30 */ /* [25] */
	{ ACT_WRITE, 0x00e5, 0x0004, { 0x89, 0x10, 0x00, 0x01 } }, /*  31 */ /* [26] */
	{  ACT_READ, 0x00e7, 0x0008, { 0x25, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00 } }, /*  32 */ /* [27] */
	{ ACT_SETIF, ISOCH_IFNUM, 0x0000, { 0x00 } }, /*  33 */ /* [28] */
	{ ACT_WRITE, 0x009a, 0x0001, { 0x01 } }, /*  34 */ /* [29] */
	{ ACT_WRITE, 0x0010, 0x0001, { 0x30 } }, /*  35 */ /* [30] */
	{ ACT_WRITE, 0x0012, 0x0005, { 0x08, 0x05, 0x07, 0x04, 0x24 } }, /*  36 */ /* [31] */
	{ ACT_WRITE, 0x0017, 0x0008, { 0x0a, 0x00, 0xf2, 0x01, 0x0f, 0x00, 0x97, 0x02 } }, /*  37 */ /* [32] */
	{ ACT_WRITE, 0x00c0, 0x0001, { 0x00 } }, /*  38 */ /* [33] */
	{ ACT_WRITE, 0x00c1, 0x0001, { 0x04 } }, /*  39 */ /* [34] */
	{ ACT_WRITE, 0x00c2, 0x0001, { 0x04 } }, /*  40 */ /* [35] */
	{ ACT_WRITE, 0x0061, 0x0008, { 0x7f, 0x7f, 0x40, 0x01, 0xf0, 0x00, 0x02, 0x01 } }, /*  41 */ /* [36] */
	{ ACT_WRITE, 0x00ca, 0x0008, { 0x00, 0x01, 0x01, 0x01, 0x10, 0x00, 0x02, 0x01 } }, /*  42 */ /* [37] */
	{ ACT_WRITE, 0x00d2, 0x0008, { 0x25, 0xc9, 0xfa, 0x4c, 0x94, 0xb7, 0x45, 0xed } }, /*  43 */ /* [38] */
	{ ACT_WRITE, 0x00da, 0x0006, { 0x30, 0x00, 0x00, 0x00, 0x04, 0x00 } }, /*  44 */ /* [39] */
	{ ACT_WRITE, 0x0041, 0x0008, { 0xda, 0xff, 0xed, 0xff, 0xc2, 0xff, 0xbc, 0xff } }, /*  45 */ /* [40] */
	{ ACT_WRITE, 0x0049, 0x0008, { 0xf5, 0xff, 0x66, 0xff, 0x7d, 0x02, 0x43, 0x02 } }, /*  46 */ /* [41] */
	{ ACT_WRITE, 0x0051, 0x0002, { 0x01, 0x04 } }, /*  47 */ /* [42] */
	{  ACT_READ, 0x0010, 0x0001, { 0x30 } }, /*  48 */ /* [43] */
	{ ACT_WRITE, 0x006a, 0x0001, { 0x02 } }, /*  49 */ /* [44] */
	{ ACT_WRITE, 0x006b, 0x0003, { 0x00, 0x02, 0x00 } }, /*  50 */ /* [45] */
	{ ACT_WRITE, 0x006b, 0x0003, { 0x01, 0x43, 0x00 } }, /*  51 */ /* [46] */
	{ ACT_WRITE, 0x006b, 0x0003, { 0x02, 0xa7, 0x00 } }, /*  52 */ /* [47] */
	{ ACT_WRITE, 0x006b, 0x0003, { 0x03, 0x8b, 0x01 } }, /*  53 */ /* [48] */
	{ ACT_WRITE, 0x006b, 0x0003, { 0x04, 0xe9, 0x02 } }, /*  54 */ /* [49] */
	{ ACT_WRITE, 0x006b, 0x0003, { 0x05, 0x08, 0x04 } }, /*  55 */ /* [50] */
	{ ACT_WRITE, 0x006b, 0x0003, { 0x06, 0x08, 0x05 } }, /*  56 */ /* [51] */
	{ ACT_WRITE, 0x006b, 0x0003, { 0x07, 0x07, 0x06 } }, /*  57 */ /* [52] */
	{ ACT_WRITE, 0x006b, 0x0003, { 0x08, 0xe7, 0x06 } }, /*  58 */ /* [53] */
	{ ACT_WRITE, 0x006b, 0x0003, { 0x09, 0xc6, 0x07 } }, /*  59 */ /* [54] */
	{ ACT_WRITE, 0x006b, 0x0003, { 0x0a, 0x86, 0x08 } }, /*  60 */ /* [55] */
	{ ACT_WRITE, 0x006b, 0x0003, { 0x0b, 0x46, 0x09 } }, /*  61 */ /* [56] */
	{ ACT_WRITE, 0x006b, 0x0003, { 0x0c, 0x05, 0x0a } }, /*  62 */ /* [57] */
	{ ACT_WRITE, 0x006b, 0x0003, { 0x0d, 0xa5, 0x0a } }, /*  63 */ /* [58] */
	{ ACT_WRITE, 0x006b, 0x0003, { 0x0e, 0x45, 0x0b } }, /*  64 */ /* [59] */
	{ ACT_WRITE, 0x006b, 0x0003, { 0x0f, 0xe5, 0x0b } }, /*  65 */ /* [60] */
	{ ACT_WRITE, 0x006b, 0x0003, { 0x10, 0x85, 0x0c } }, /*  66 */ /* [61] */
	{ ACT_WRITE, 0x006b, 0x0003, { 0x11, 0x25, 0x0d } }, /*  67 */ /* [62] */
	{ ACT_WRITE, 0x006b, 0x0003, { 0x12, 0xc4, 0x0d } }, /*  68 */ /* [63] */
	{ ACT_WRITE, 0x006b, 0x0003, { 0x13, 0x45, 0x0e } }, /*  69 */ /* [64] */
	{ ACT_WRITE, 0x006b, 0x0003, { 0x14, 0xe4, 0x0e } }, /*  70 */ /* [65] */
	{ ACT_WRITE, 0x006b, 0x0003, { 0x15, 0x64, 0x0f } }, /*  71 */ /* [66] */
	{ ACT_WRITE, 0x006b, 0x0003, { 0x16, 0xe4, 0x0f } }, /*  72 */ /* [67] */
	{ ACT_WRITE, 0x006b, 0x0003, { 0x17, 0x64, 0x10 } }, /*  73 */ /* [68] */
	{ ACT_WRITE, 0x006b, 0x0003, { 0x18, 0xe4, 0x10 } }, /*  74 */ /* [69] */
	{ ACT_WRITE, 0x006b, 0x0003, { 0x19, 0x64, 0x11 } }, /*  75 */ /* [70] */
	{ ACT_WRITE, 0x006b, 0x0003, { 0x1a, 0xe4, 0x11 } }, /*  76 */ /* [71] */
	{ ACT_WRITE, 0x006b, 0x0003, { 0x1b, 0x64, 0x12 } }, /*  77 */ /* [72] */
	{ ACT_WRITE, 0x006b, 0x0003, { 0x1c, 0xe3, 0x12 } }, /*  78 */ /* [73] */
	{ ACT_WRITE, 0x006b, 0x0003, { 0x1d, 0x44, 0x13 } }, /*  79 */ /* [74] */
	{ ACT_WRITE, 0x006b, 0x0003, { 0x1e, 0xc3, 0x13 } }, /*  80 */ /* [75] */
	{ ACT_WRITE, 0x006b, 0x0003, { 0x1f, 0x24, 0x14 } }, /*  81 */ /* [76] */
	{ ACT_WRITE, 0x006b, 0x0003, { 0x20, 0xa3, 0x14 } }, /*  82 */ /* [77] */
	{ ACT_WRITE, 0x006b, 0x0003, { 0x21, 0x04, 0x15 } }, /*  83 */ /* [78] */
	{ ACT_WRITE, 0x006b, 0x0003, { 0x22, 0x83, 0x15 } }, /*  84 */ /* [79] */
	{ ACT_WRITE, 0x006b, 0x0003, { 0x23, 0xe3, 0x15 } }, /*  85 */ /* [80] */
	{ ACT_WRITE, 0x006b, 0x0003, { 0x24, 0x43, 0x16 } }, /*  86 */ /* [81] */
	{ ACT_WRITE, 0x006b, 0x0003, { 0x25, 0xa4, 0x16 } }, /*  87 */ /* [82] */
	{ ACT_WRITE, 0x006b, 0x0003, { 0x26, 0x23, 0x17 } }, /*  88 */ /* [83] */
	{ ACT_WRITE, 0x006b, 0x0003, { 0x27, 0x83, 0x17 } }, /*  89 */ /* [84] */
	{ ACT_WRITE, 0x006b, 0x0003, { 0x28, 0xe3, 0x17 } }, /*  90 */ /* [85] */
	{ ACT_WRITE, 0x006b, 0x0003, { 0x29, 0x43, 0x18 } }, /*  91 */ /* [86] */
	{ ACT_WRITE, 0x006b, 0x0003, { 0x2a, 0xa3, 0x18 } }, /*  92 */ /* [87] */
	{ ACT_WRITE, 0x006b, 0x0003, { 0x2b, 0x03, 0x19 } }, /*  93 */ /* [88] */
	{ ACT_WRITE, 0x006b, 0x0003, { 0x2c, 0x63, 0x19 } }, /*  94 */ /* [89] */
	{ ACT_WRITE, 0x006b, 0x0003, { 0x2d, 0xc3, 0x19 } }, /*  95 */ /* [90] */
	{ ACT_WRITE, 0x006b, 0x0003, { 0x2e, 0x22, 0x1a } }, /*  96 */ /* [91] */
	{ ACT_WRITE, 0x006b, 0x0003, { 0x2f, 0x63, 0x1a } }, /*  97 */ /* [92] */
	{ ACT_WRITE, 0x006b, 0x0003, { 0x30, 0xc3, 0x1a } }, /*  98 */ /* [93] */
	{ ACT_WRITE, 0x006b, 0x0003, { 0x31, 0x23, 0x1b } }, /*  99 */ /* [94] */
	{ ACT_WRITE, 0x006b, 0x0003, { 0x32, 0x83, 0x1b } }, /* 100 */ /* [95] */
	{ ACT_WRITE, 0x006b, 0x0003, { 0x33, 0xe2, 0x1b } }, /* 101 */ /* [96] */
	{ ACT_WRITE, 0x006b, 0x0003, { 0x34, 0x23, 0x1c } }, /* 102 */ /* [97] */
	{ ACT_WRITE, 0x006b, 0x0003, { 0x35, 0x83, 0x1c } }, /* 103 */ /* [98] */
	{ ACT_WRITE, 0x006b, 0x0003, { 0x36, 0xe2, 0x1c } }, /* 104 */ /* [99] */
	{ ACT_WRITE, 0x006b, 0x0003, { 0x37, 0x23, 0x1d } }, /* 105 */ /* [100] */
	{ ACT_WRITE, 0x006b, 0x0003, { 0x38, 0x83, 0x1d } }, /* 106 */ /* [101] */
	{ ACT_WRITE, 0x006b, 0x0003, { 0x39, 0xe2, 0x1d } }, /* 107 */ /* [102] */
	{ ACT_WRITE, 0x006b, 0x0003, { 0x3a, 0x23, 0x1e } }, /* 108 */ /* [103] */
	{ ACT_WRITE, 0x006b, 0x0003, { 0x3b, 0x82, 0x1e } }, /* 109 */ /* [104] */
	{ ACT_WRITE, 0x006b, 0x0003, { 0x3c, 0xc3, 0x1e } }, /* 110 */ /* [105] */
	{ ACT_WRITE, 0x006b, 0x0003, { 0x3d, 0x22, 0x1f } }, /* 111 */ /* [106] */
	{ ACT_WRITE, 0x006b, 0x0003, { 0x3e, 0x63, 0x1f } }, /* 112 */ /* [107] */
	{ ACT_WRITE, 0x006b, 0x0003, { 0x3f, 0xc1, 0x1f } }, /* 113 */ /* [108] */
	{ ACT_WRITE, 0x006a, 0x0001, { 0x00 } }, /* 114 */ /* [109] */
	{ ACT_WRITE, 0x0020, 0x0008, { 0x10, 0x42, 0x81, 0x19, 0xd3, 0xff, 0xa7, 0xff } }, /* 115 */ /* [110] */
	{ ACT_WRITE, 0x0028, 0x0008, { 0x87, 0x00, 0x87, 0x00, 0x8f, 0xff, 0xea, 0xff } }, /* 116 */ /* [111] */
	{ ACT_WRITE, 0x0010, 0x0002, { 0xb1, 0xb1 } }, /* 117 */ /* [112] */
	{ ACT_WRITE, 0x0092, 0x0001, { 0x03 } }, /* 118 */ /* [113] */
	{ ACT_WRITE, 0x0071, 0x0004, { 0x04, 0x0c, 0x05, 0x0f } }, /* 119 */ /* [114] */
	{ ACT_WRITE, 0x007b, 0x0006, { 0x00, 0xff, 0x00, 0xff, 0x00, 0xff } }, /* 120 */ /* [115] */
	{ ACT_WRITE, 0x00f8, 0x0001, { 0x00 } }, /* 121 */ /* [116] */
	{ ACT_WRITE, 0x0010, 0x0002, { 0xb1, 0xb1 } }, /* 122 */ /* [117] */
	{ ACT_WRITE, 0x0098, 0x0001, { 0x41 } }, /* 123 */ /* [118] */
	{ ACT_WRITE, 0x00e5, 0x0004, { 0x88, 0x12, 0x70, 0x01 } }, /* 124 */ /* [119] */
	{  ACT_READ, 0x00e8, 0x0001, { 0x00 } }, /* 125 */ /* [120] */
	{ ACT_WRITE, 0x00e5, 0x0004, { 0x88, 0x0d, 0x02, 0x01 } }, /* 126 */ /* [121] */
	{  ACT_READ, 0x00e8, 0x0001, { 0x00 } }, /* 127 */ /* [122] */
	{ ACT_WRITE, 0x00e5, 0x0004, { 0x88, 0x0f, 0x00, 0x01 } }, /* 128 */ /* [123] */
	{  ACT_READ, 0x00e8, 0x0001, { 0x00 } }, /* 129 */ /* [124] */
	{ ACT_WRITE, 0x00e5, 0x0008, { 0x88, 0x03, 0x71, 0x01, 0x88, 0x04, 0x00, 0x01 } }, /* 130 */ /* [125] */
	{  ACT_READ, 0x00e8, 0x0008, { 0x00, 0x88, 0x04, 0x00, 0x00, 0x01, 0x00, 0x00 } }, /* 131 */ /* [126] */
	{ ACT_WRITE, 0x00e5, 0x0004, { 0x88, 0x02, 0x10, 0x01 } }, /* 132 */ /* [127] */
	{  ACT_READ, 0x00e8, 0x0001, { 0x00 } }, /* 133 */ /* [128] */
	{ ACT_WRITE, 0x00e5, 0x0008, { 0x88, 0x00, 0x88, 0x01, 0x88, 0x01, 0x01, 0x01 } }, /* 134 */ /* [129] */
	{  ACT_READ, 0x00e8, 0x0008, { 0x00, 0x88, 0x01, 0x00, 0x00, 0x01, 0x00, 0x00 } }, /* 135 */ /* [130] */
	{ ACT_WRITE, 0x00e5, 0x0004, { 0x88, 0x0b, 0x00, 0x01 } }, /* 136 */ /* [131] */
	{  ACT_READ, 0x00e8, 0x0001, { 0x00 } }, /* 137 */ /* [132] */
	{ ACT_WRITE, 0x00e5, 0x0004, { 0x88, 0x0a, 0x0a, 0x01 } }, /* 138 */ /* [133] */
	{  ACT_READ, 0x00e8, 0x0001, { 0x00 } }, /* 139 */ /* [134] */
	{ ACT_WRITE, 0x00e5, 0x0008, { 0x88, 0x00, 0x08, 0x01, 0x88, 0x01, 0x00, 0x01 } }, /* 140 */ /* [135] */
	{  ACT_READ, 0x00e8, 0x0008, { 0x00, 0x88, 0x01, 0x00, 0x00, 0x01, 0x00, 0x00 } }, /* 141 */ /* [136] */
	{ ACT_WRITE, 0x00e5, 0x0004, { 0x88, 0x05, 0x01, 0x01 } }, /* 142 */ /* [137] */
	{  ACT_READ, 0x00e8, 0x0001, { 0x00 } }, /* 143 */ /* [138] */
	{  ACT_READ, 0x00c3, 0x0001, { 0x00 } }, /* 144 */ /* [139] */
	{ ACT_WRITE, 0x00e5, 0x0004, { 0xa1, 0x18, 0x00, 0x01 } }, /* 145 */ /* [140] */
	{  ACT_READ, 0x00e7, 0x0008, { 0xff, 0x02, 0x88, 0x01, 0x00, 0x00, 0x01, 0x00 } }, /* 146 */ /* [141] */
	{ ACT_WRITE, 0x00c0, 0x0001, { 0x01 } }, /* 147 */ /* [142] */
	{ ACT_WRITE, 0x00c3, 0x0001, { 0x00 } }, /* 148 */ /* [143] */
	{ ACT_WRITE, 0x00c0, 0x0001, { 0x00 } }, /* 149 */ /* [144] */
	{  ACT_READ, 0x0001, 0x0001, { 0x10 } }, /* 150 */ /* [145] */
	{ ACT_WRITE, 0x0008, 0x0008, { 0xff, 0xd8, 0xff, 0xdb, 0x00, 0x84, 0x00, 0x05 } }, /* 151 */ /* [146] */
	{ ACT_WRITE, 0x0008, 0x0008, { 0x03, 0x04, 0x04, 0x04, 0x03, 0x05, 0x04, 0x04 } }, /* 152 */ /* [147] */
	{ ACT_WRITE, 0x0008, 0x0008, { 0x04, 0x05, 0x05, 0x05, 0x06, 0x07, 0x0c, 0x08 } }, /* 153 */ /* [148] */
	{ ACT_WRITE, 0x0008, 0x0008, { 0x07, 0x07, 0x07, 0x07, 0x0f, 0x0b, 0x0b, 0x09 } }, /* 154 */ /* [149] */
	{ ACT_WRITE, 0x0008, 0x0008, { 0x0c, 0x11, 0x0f, 0x12, 0x12, 0x11, 0x0f, 0x11 } }, /* 155 */ /* [150] */
	{ ACT_WRITE, 0x0008, 0x0008, { 0x11, 0x13, 0x16, 0x1c, 0x17, 0x13, 0x14, 0x1a } }, /* 156 */ /* [151] */
	{ ACT_WRITE, 0x0008, 0x0008, { 0x15, 0x11, 0x11, 0x18, 0x21, 0x18, 0x1a, 0x1d } }, /* 157 */ /* [152] */
	{ ACT_WRITE, 0x0008, 0x0008, { 0x1d, 0x1f, 0x1f, 0x1f, 0x13, 0x17, 0x22, 0x24 } }, /* 158 */ /* [153] */
	{ ACT_WRITE, 0x0008, 0x0008, { 0x22, 0x1e, 0x24, 0x1c, 0x1e, 0x1f, 0x1e, 0x01 } }, /* 159 */ /* [154] */
	{ ACT_WRITE, 0x0008, 0x0008, { 0x05, 0x03, 0x04, 0x04, 0x04, 0x03, 0x05, 0x04 } }, /* 160 */ /* [155] */
	{ ACT_WRITE, 0x0008, 0x0008, { 0x04, 0x04, 0x05, 0x05, 0x05, 0x06, 0x07, 0x0c } }, /* 161 */ /* [156] */
	{ ACT_WRITE, 0x0008, 0x0008, { 0x08, 0x07, 0x07, 0x07, 0x07, 0x0f, 0x0b, 0x0b } }, /* 162 */ /* [157] */
	{ ACT_WRITE, 0x0008, 0x0008, { 0x09, 0x0c, 0x11, 0x0f, 0x12, 0x12, 0x11, 0x0f } }, /* 163 */ /* [158] */
	{ ACT_WRITE, 0x0008, 0x0008, { 0x11, 0x11, 0x13, 0x16, 0x1c, 0x17, 0x13, 0x14 } }, /* 164 */ /* [159] */
	{ ACT_WRITE, 0x0008, 0x0008, { 0x1a, 0x15, 0x11, 0x11, 0x18, 0x21, 0x18, 0x1a } }, /* 165 */ /* [160] */
	{ ACT_WRITE, 0x0008, 0x0008, { 0x1d, 0x1d, 0x1f, 0x1f, 0x1f, 0x13, 0x17, 0x22 } }, /* 166 */ /* [161] */
	{ ACT_WRITE, 0x0008, 0x0008, { 0x24, 0x22, 0x1e, 0x24, 0x1c, 0x1e, 0x1f, 0x1e } }, /* 167 */ /* [162] */
	{ ACT_WRITE, 0x0008, 0x0008, { 0xff, 0xc4, 0x01, 0xa2, 0x00, 0x00, 0x01, 0x05 } }, /* 168 */ /* [163] */
	{ ACT_WRITE, 0x0008, 0x0008, { 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x00, 0x00 } }, /* 169 */ /* [164] */
	{ ACT_WRITE, 0x0008, 0x0008, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x02 } }, /* 170 */ /* [165] */
	{ ACT_WRITE, 0x0008, 0x0008, { 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0a } }, /* 171 */ /* [166] */
	{ ACT_WRITE, 0x0008, 0x0008, { 0x0b, 0x01, 0x00, 0x03, 0x01, 0x01, 0x01, 0x01 } }, /* 172 */ /* [167] */
	{ ACT_WRITE, 0x0008, 0x0008, { 0x01, 0x01, 0x01, 0x01, 0x01, 0x00, 0x00, 0x00 } }, /* 173 */ /* [168] */
	{ ACT_WRITE, 0x0008, 0x0008, { 0x00, 0x00, 0x00, 0x01, 0x02, 0x03, 0x04, 0x05 } }, /* 174 */ /* [169] */
	{ ACT_WRITE, 0x0008, 0x0008, { 0x06, 0x07, 0x08, 0x09, 0x0a, 0x0b, 0x10, 0x00 } }, /* 175 */ /* [170] */
	{ ACT_WRITE, 0x0008, 0x0008, { 0x02, 0x01, 0x03, 0x03, 0x02, 0x04, 0x03, 0x05 } }, /* 176 */ /* [171] */
	{ ACT_WRITE, 0x0008, 0x0008, { 0x05, 0x04, 0x04, 0x00, 0x00, 0x01, 0x7d, 0x01 } }, /* 177 */ /* [172] */
	{ ACT_WRITE, 0x0008, 0x0008, { 0x02, 0x03, 0x00, 0x04, 0x11, 0x05, 0x12, 0x21 } }, /* 178 */ /* [173] */
	{ ACT_WRITE, 0x0008, 0x0008, { 0x31, 0x41, 0x06, 0x13, 0x51, 0x61, 0x07, 0x22 } }, /* 179 */ /* [174] */
	{ ACT_WRITE, 0x0008, 0x0008, { 0x71, 0x14, 0x32, 0x81, 0x91, 0xa1, 0x08, 0x23 } }, /* 180 */ /* [175] */
	{ ACT_WRITE, 0x0008, 0x0008, { 0x42, 0xb1, 0xc1, 0x15, 0x52, 0xd1, 0xf0, 0x24 } }, /* 181 */ /* [176] */
	{ ACT_WRITE, 0x0008, 0x0008, { 0x33, 0x62, 0x72, 0x82, 0x09, 0x0a, 0x16, 0x17 } }, /* 182 */ /* [177] */
	{ ACT_WRITE, 0x0008, 0x0008, { 0x18, 0x19, 0x1a, 0x25, 0x26, 0x27, 0x28, 0x29 } }, /* 183 */ /* [178] */
	{ ACT_WRITE, 0x0008, 0x0008, { 0x2a, 0x34, 0x35, 0x36, 0x37, 0x38, 0x39, 0x3a } }, /* 184 */ /* [179] */
	{ ACT_WRITE, 0x0008, 0x0008, { 0x43, 0x44, 0x45, 0x46, 0x47, 0x48, 0x49, 0x4a } }, /* 185 */ /* [180] */
	{ ACT_WRITE, 0x0008, 0x0008, { 0x53, 0x54, 0x55, 0x56, 0x57, 0x58, 0x59, 0x5a } }, /* 186 */ /* [181] */
	{ ACT_WRITE, 0x0008, 0x0008, { 0x63, 0x64, 0x65, 0x66, 0x67, 0x68, 0x69, 0x6a } }, /* 187 */ /* [182] */
	{ ACT_WRITE, 0x0008, 0x0008, { 0x73, 0x74, 0x75, 0x76, 0x77, 0x78, 0x79, 0x7a } }, /* 188 */ /* [183] */
	{ ACT_WRITE, 0x0008, 0x0008, { 0x83, 0x84, 0x85, 0x86, 0x87, 0x88, 0x89, 0x8a } }, /* 189 */ /* [184] */
	{ ACT_WRITE, 0x0008, 0x0008, { 0x92, 0x93, 0x94, 0x95, 0x96, 0x97, 0x98, 0x99 } }, /* 190 */ /* [185] */
	{ ACT_WRITE, 0x0008, 0x0008, { 0x9a, 0xa2, 0xa3, 0xa4, 0xa5, 0xa6, 0xa7, 0xa8 } }, /* 191 */ /* [186] */
	{ ACT_WRITE, 0x0008, 0x0008, { 0xa9, 0xaa, 0xb2, 0xb3, 0xb4, 0xb5, 0xb6, 0xb7 } }, /* 192 */ /* [187] */
	{ ACT_WRITE, 0x0008, 0x0008, { 0xb8, 0xb9, 0xba, 0xc2, 0xc3, 0xc4, 0xc5, 0xc6 } }, /* 193 */ /* [188] */
	{ ACT_WRITE, 0x0008, 0x0008, { 0xc7, 0xc8, 0xc9, 0xca, 0xd2, 0xd3, 0xd4, 0xd5 } }, /* 194 */ /* [189] */
	{ ACT_WRITE, 0x0008, 0x0008, { 0xd6, 0xd7, 0xd8, 0xd9, 0xda, 0xe1, 0xe2, 0xe3 } }, /* 195 */ /* [190] */
	{ ACT_WRITE, 0x0008, 0x0008, { 0xe4, 0xe5, 0xe6, 0xe7, 0xe8, 0xe9, 0xea, 0xf1 } }, /* 196 */ /* [191] */
	{ ACT_WRITE, 0x0008, 0x0008, { 0xf2, 0xf3, 0xf4, 0xf5, 0xf6, 0xf7, 0xf8, 0xf9 } }, /* 197 */ /* [192] */
	{ ACT_WRITE, 0x0008, 0x0008, { 0xfa, 0x11, 0x00, 0x02, 0x01, 0x02, 0x04, 0x04 } }, /* 198 */ /* [193] */
	{ ACT_WRITE, 0x0008, 0x0008, { 0x03, 0x04, 0x07, 0x05, 0x04, 0x04, 0x00, 0x01 } }, /* 199 */ /* [194] */
	{ ACT_WRITE, 0x0008, 0x0008, { 0x02, 0x77, 0x00, 0x01, 0x02, 0x03, 0x11, 0x04 } }, /* 200 */ /* [195] */
	{ ACT_WRITE, 0x0008, 0x0008, { 0x05, 0x21, 0x31, 0x06, 0x12, 0x41, 0x51, 0x07 } }, /* 201 */ /* [196] */
	{ ACT_WRITE, 0x0008, 0x0008, { 0x61, 0x71, 0x13, 0x22, 0x32, 0x81, 0x08, 0x14 } }, /* 202 */ /* [197] */
	{ ACT_WRITE, 0x0008, 0x0008, { 0x42, 0x91, 0xa1, 0xb1, 0xc1, 0x09, 0x23, 0x33 } }, /* 203 */ /* [198] */
	{ ACT_WRITE, 0x0008, 0x0008, { 0x52, 0xf0, 0x15, 0x62, 0x72, 0xd1, 0x0a, 0x16 } }, /* 204 */ /* [199] */
	{ ACT_WRITE, 0x0008, 0x0008, { 0x24, 0x34, 0xe1, 0x25, 0xf1, 0x17, 0x18, 0x19 } }, /* 205 */ /* [200] */
	{ ACT_WRITE, 0x0008, 0x0008, { 0x1a, 0x26, 0x27, 0x28, 0x29, 0x2a, 0x35, 0x36 } }, /* 206 */ /* [201] */
	{ ACT_WRITE, 0x0008, 0x0008, { 0x37, 0x38, 0x39, 0x3a, 0x43, 0x44, 0x45, 0x46 } }, /* 207 */ /* [202] */
	{ ACT_WRITE, 0x0008, 0x0008, { 0x47, 0x48, 0x49, 0x4a, 0x53, 0x54, 0x55, 0x56 } }, /* 208 */ /* [203] */
	{ ACT_WRITE, 0x0008, 0x0008, { 0x57, 0x58, 0x59, 0x5a, 0x63, 0x64, 0x65, 0x66 } }, /* 209 */ /* [204] */
	{ ACT_WRITE, 0x0008, 0x0008, { 0x67, 0x68, 0x69, 0x6a, 0x73, 0x74, 0x75, 0x76 } }, /* 210 */ /* [205] */
	{ ACT_WRITE, 0x0008, 0x0008, { 0x77, 0x78, 0x79, 0x7a, 0x82, 0x83, 0x84, 0x85 } }, /* 211 */ /* [206] */
	{ ACT_WRITE, 0x0008, 0x0008, { 0x86, 0x87, 0x88, 0x89, 0x8a, 0x92, 0x93, 0x94 } }, /* 212 */ /* [207] */
	{ ACT_WRITE, 0x0008, 0x0008, { 0x95, 0x96, 0x97, 0x98, 0x99, 0x9a, 0xa2, 0xa3 } }, /* 213 */ /* [208] */
	{ ACT_WRITE, 0x0008, 0x0008, { 0xa4, 0xa5, 0xa6, 0xa7, 0xa8, 0xa9, 0xaa, 0xb2 } }, /* 214 */ /* [209] */
	{ ACT_WRITE, 0x0008, 0x0008, { 0xb3, 0xb4, 0xb5, 0xb6, 0xb7, 0xb8, 0xb9, 0xba } }, /* 215 */ /* [210] */
	{ ACT_WRITE, 0x0008, 0x0008, { 0xc2, 0xc3, 0xc4, 0xc5, 0xc6, 0xc7, 0xc8, 0xc9 } }, /* 216 */ /* [211] */
	{ ACT_WRITE, 0x0008, 0x0008, { 0xca, 0xd2, 0xd3, 0xd4, 0xd5, 0xd6, 0xd7, 0xd8 } }, /* 217 */ /* [212] */
	{ ACT_WRITE, 0x0008, 0x0008, { 0xd9, 0xda, 0xe2, 0xe3, 0xe4, 0xe5, 0xe6, 0xe7 } }, /* 218 */ /* [213] */
	{ ACT_WRITE, 0x0008, 0x0008, { 0xe8, 0xe9, 0xea, 0xf2, 0xf3, 0xf4, 0xf5, 0xf6 } }, /* 219 */ /* [214] */
	{ ACT_WRITE, 0x0008, 0x0008, { 0xf7, 0xf8, 0xf9, 0xfa, 0xff, 0x20, 0x00, 0x1f } }, /* 220 */ /* [215] */
	{ ACT_WRITE, 0x0008, 0x0008, { 0x02, 0x0c, 0x00, 0x00, 0x0a, 0x00, 0x00, 0x00 } }, /* 221 */ /* [216] */
	{ ACT_WRITE, 0x0008, 0x0008, { 0x00, 0x00, 0x11, 0x00, 0x11, 0x22, 0x00, 0x22 } }, /* 222 */ /* [217] */
	{ ACT_WRITE, 0x0008, 0x0008, { 0x22, 0x11, 0x22, 0x22, 0x11, 0x33, 0x33, 0x11 } }, /* 223 */ /* [218] */
	{ ACT_WRITE, 0x0008, 0x0008, { 0x44, 0x66, 0x22, 0x55, 0x66, 0xff, 0xdd, 0x00 } }, /* 224 */ /* [219] */
	{ ACT_WRITE, 0x0008, 0x0008, { 0x04, 0x00, 0x14, 0xff, 0xc0, 0x00, 0x11, 0x08 } }, /* 225 */ /* [220] */
	{ ACT_WRITE, 0x0008, 0x0008, { 0x00, 0xf0, 0x01, 0x40, 0x03, 0x00, 0x21, 0x00 } }, /* 226 */ /* [221] */
	{ ACT_WRITE, 0x0008, 0x0008, { 0x01, 0x11, 0x01, 0x02, 0x11, 0x01, 0xff, 0xda } }, /* 227 */ /* [222] */
	{ ACT_WRITE, 0x0008, 0x0008, { 0x00, 0x0c, 0x03, 0x00, 0x00, 0x01, 0x11, 0x02 } }, /* 228 */ /* [223] */
	{ ACT_WRITE, 0x0008, 0x0006, { 0x11, 0x00, 0x3f, 0x00, 0xff, 0xd9 } }, /* 229 */ /* [224] */
	{  ACT_READ, 0x0002, 0x0001, { 0x00 } }, /* 230 */ /* [225] */
	{ ACT_WRITE, 0x0055, 0x0001, { 0x14 } }, /* 231 */ /* [226] */
	{ ACT_SETIF,   0x00, 0x0000, { 0x00 } }, /* 232 */ /* [227] */
	{ ACT_WRITE, 0x00e5, 0x0004, { 0x89, 0x10, 0x00, 0x01 } }, /* 233 */ /* [228] */
	{  ACT_READ, 0x00e7, 0x0008, { 0x25, 0x00, 0x88, 0x01, 0x00, 0x00, 0x01, 0x00 } }, /* 234 */ /* [229] */
	{ ACT_SETIF, ISOCH_IFNUM, 0x0000, { 0x00 } }, /* 235 */ /* [230] */
	{ ACT_WRITE, 0x009a, 0x0001, { 0x01 } }, /* 236 */ /* [231] */
	{ ACT_WRITE, 0x0010, 0x0001, { 0x30 } }, /* 237 */ /* [232] */
	{ ACT_WRITE, 0x0012, 0x0005, { 0x08, 0x05, 0x07, 0x04, 0x24 } }, /* 238 */ /* [233] */
	{ ACT_WRITE, 0x0017, 0x0008, { 0x0a, 0x00, 0xf2, 0x01, 0x0f, 0x00, 0x97, 0x02 } }, /* 239 */ /* [234] */
	{ ACT_WRITE, 0x00c0, 0x0001, { 0x00 } }, /* 240 */ /* [235] */
	{ ACT_WRITE, 0x00c1, 0x0001, { 0x04 } }, /* 241 */ /* [236] */
	{ ACT_WRITE, 0x00c2, 0x0001, { 0x04 } }, /* 242 */ /* [237] */
	{ ACT_WRITE, 0x0061, 0x0008, { 0x7f, 0x7f, 0x40, 0x01, 0xf0, 0x00, 0x02, 0x01 } }, /* 243 */ /* [238] */
	{ ACT_WRITE, 0x00ca, 0x0008, { 0x00, 0x01, 0x01, 0x01, 0x10, 0x00, 0x02, 0x01 } }, /* 244 */ /* [239] */
	{ ACT_WRITE, 0x00d2, 0x0008, { 0x25, 0xc9, 0xfa, 0x4c, 0x94, 0xb7, 0x45, 0xed } }, /* 245 */ /* [240] */
	{ ACT_WRITE, 0x00da, 0x0006, { 0x30, 0x00, 0x00, 0x00, 0x04, 0x00 } }, /* 246 */ /* [241] */
	{ ACT_WRITE, 0x0041, 0x0008, { 0xda, 0xff, 0xed, 0xff, 0xc2, 0xff, 0xbc, 0xff } }, /* 247 */ /* [242] */
	{ ACT_WRITE, 0x0049, 0x0008, { 0xf5, 0xff, 0x66, 0xff, 0x7d, 0x02, 0x43, 0x02 } }, /* 248 */ /* [243] */
	{ ACT_WRITE, 0x0051, 0x0002, { 0x01, 0x04 } }, /* 249 */ /* [244] */
	{  ACT_READ, 0x0010, 0x0001, { 0x31 } }, /* 250 */ /* [245] */
	{ ACT_WRITE, 0x006a, 0x0001, { 0x02 } }, /* 251 */ /* [246] */
	{ ACT_WRITE, 0x006b, 0x0003, { 0x00, 0x02, 0x00 } }, /* 252 */ /* [247] */
	{ ACT_WRITE, 0x006b, 0x0003, { 0x01, 0x43, 0x00 } }, /* 253 */ /* [248] */
	{ ACT_WRITE, 0x006b, 0x0003, { 0x02, 0xa7, 0x00 } }, /* 254 */ /* [249] */
	{ ACT_WRITE, 0x006b, 0x0003, { 0x03, 0x8b, 0x01 } }, /* 255 */ /* [250] */
	{ ACT_WRITE, 0x006b, 0x0003, { 0x04, 0xe9, 0x02 } }, /* 256 */ /* [251] */
	{ ACT_WRITE, 0x006b, 0x0003, { 0x05, 0x08, 0x04 } }, /* 257 */ /* [252] */
	{ ACT_WRITE, 0x006b, 0x0003, { 0x06, 0x08, 0x05 } }, /* 258 */ /* [253] */
	{ ACT_WRITE, 0x006b, 0x0003, { 0x07, 0x07, 0x06 } }, /* 259 */ /* [254] */
	{ ACT_WRITE, 0x006b, 0x0003, { 0x08, 0xe7, 0x06 } }, /* 260 */ /* [255] */
	{ ACT_WRITE, 0x006b, 0x0003, { 0x09, 0xc6, 0x07 } }, /* 261 */ /* [256] */
	{ ACT_WRITE, 0x006b, 0x0003, { 0x0a, 0x86, 0x08 } }, /* 262 */ /* [257] */
	{ ACT_WRITE, 0x006b, 0x0003, { 0x0b, 0x46, 0x09 } }, /* 263 */ /* [258] */
	{ ACT_WRITE, 0x006b, 0x0003, { 0x0c, 0x05, 0x0a } }, /* 264 */ /* [259] */
	{ ACT_WRITE, 0x006b, 0x0003, { 0x0d, 0xa5, 0x0a } }, /* 265 */ /* [260] */
	{ ACT_WRITE, 0x006b, 0x0003, { 0x0e, 0x45, 0x0b } }, /* 266 */ /* [261] */
	{ ACT_WRITE, 0x006b, 0x0003, { 0x0f, 0xe5, 0x0b } }, /* 267 */ /* [262] */
	{ ACT_WRITE, 0x006b, 0x0003, { 0x10, 0x85, 0x0c } }, /* 268 */ /* [263] */
	{ ACT_WRITE, 0x006b, 0x0003, { 0x11, 0x25, 0x0d } }, /* 269 */ /* [264] */
	{ ACT_WRITE, 0x006b, 0x0003, { 0x12, 0xc4, 0x0d } }, /* 270 */ /* [265] */
	{ ACT_WRITE, 0x006b, 0x0003, { 0x13, 0x45, 0x0e } }, /* 271 */ /* [266] */
	{ ACT_WRITE, 0x006b, 0x0003, { 0x14, 0xe4, 0x0e } }, /* 272 */ /* [267] */
	{ ACT_WRITE, 0x006b, 0x0003, { 0x15, 0x64, 0x0f } }, /* 273 */ /* [268] */
	{ ACT_WRITE, 0x006b, 0x0003, { 0x16, 0xe4, 0x0f } }, /* 274 */ /* [269] */
	{ ACT_WRITE, 0x006b, 0x0003, { 0x17, 0x64, 0x10 } }, /* 275 */ /* [270] */
	{ ACT_WRITE, 0x006b, 0x0003, { 0x18, 0xe4, 0x10 } }, /* 276 */ /* [271] */
	{ ACT_WRITE, 0x006b, 0x0003, { 0x19, 0x64, 0x11 } }, /* 277 */ /* [272] */
	{ ACT_WRITE, 0x006b, 0x0003, { 0x1a, 0xe4, 0x11 } }, /* 278 */ /* [273] */
	{ ACT_WRITE, 0x006b, 0x0003, { 0x1b, 0x64, 0x12 } }, /* 279 */ /* [274] */
	{ ACT_WRITE, 0x006b, 0x0003, { 0x1c, 0xe3, 0x12 } }, /* 280 */ /* [275] */
	{ ACT_WRITE, 0x006b, 0x0003, { 0x1d, 0x44, 0x13 } }, /* 281 */ /* [276] */
	{ ACT_WRITE, 0x006b, 0x0003, { 0x1e, 0xc3, 0x13 } }, /* 282 */ /* [277] */
	{ ACT_WRITE, 0x006b, 0x0003, { 0x1f, 0x24, 0x14 } }, /* 283 */ /* [278] */
	{ ACT_WRITE, 0x006b, 0x0003, { 0x20, 0xa3, 0x14 } }, /* 284 */ /* [279] */
	{ ACT_WRITE, 0x006b, 0x0003, { 0x21, 0x04, 0x15 } }, /* 285 */ /* [280] */
	{ ACT_WRITE, 0x006b, 0x0003, { 0x22, 0x83, 0x15 } }, /* 286 */ /* [281] */
	{ ACT_WRITE, 0x006b, 0x0003, { 0x23, 0xe3, 0x15 } }, /* 287 */ /* [282] */
	{ ACT_WRITE, 0x006b, 0x0003, { 0x24, 0x43, 0x16 } }, /* 288 */ /* [283] */
	{ ACT_WRITE, 0x006b, 0x0003, { 0x25, 0xa4, 0x16 } }, /* 289 */ /* [284] */
	{ ACT_WRITE, 0x006b, 0x0003, { 0x26, 0x23, 0x17 } }, /* 290 */ /* [285] */
	{ ACT_WRITE, 0x006b, 0x0003, { 0x27, 0x83, 0x17 } }, /* 291 */ /* [286] */
	{ ACT_WRITE, 0x006b, 0x0003, { 0x28, 0xe3, 0x17 } }, /* 292 */ /* [287] */
	{ ACT_WRITE, 0x006b, 0x0003, { 0x29, 0x43, 0x18 } }, /* 293 */ /* [288] */
	{ ACT_WRITE, 0x006b, 0x0003, { 0x2a, 0xa3, 0x18 } }, /* 294 */ /* [289] */
	{ ACT_WRITE, 0x006b, 0x0003, { 0x2b, 0x03, 0x19 } }, /* 295 */ /* [290] */
	{ ACT_WRITE, 0x006b, 0x0003, { 0x2c, 0x63, 0x19 } }, /* 296 */ /* [291] */
	{ ACT_WRITE, 0x006b, 0x0003, { 0x2d, 0xc3, 0x19 } }, /* 297 */ /* [292] */
	{ ACT_WRITE, 0x006b, 0x0003, { 0x2e, 0x22, 0x1a } }, /* 298 */ /* [293] */
	{ ACT_WRITE, 0x006b, 0x0003, { 0x2f, 0x63, 0x1a } }, /* 299 */ /* [294] */
	{ ACT_WRITE, 0x006b, 0x0003, { 0x30, 0xc3, 0x1a } }, /* 300 */ /* [295] */
	{ ACT_WRITE, 0x006b, 0x0003, { 0x31, 0x23, 0x1b } }, /* 301 */ /* [296] */
	{ ACT_WRITE, 0x006b, 0x0003, { 0x32, 0x83, 0x1b } }, /* 302 */ /* [297] */
	{ ACT_WRITE, 0x006b, 0x0003, { 0x33, 0xe2, 0x1b } }, /* 303 */ /* [298] */
	{ ACT_WRITE, 0x006b, 0x0003, { 0x34, 0x23, 0x1c } }, /* 304 */ /* [299] */
	{ ACT_WRITE, 0x006b, 0x0003, { 0x35, 0x83, 0x1c } }, /* 305 */ /* [300] */
	{ ACT_WRITE, 0x006b, 0x0003, { 0x36, 0xe2, 0x1c } }, /* 306 */ /* [301] */
	{ ACT_WRITE, 0x006b, 0x0003, { 0x37, 0x23, 0x1d } }, /* 307 */ /* [302] */
	{ ACT_WRITE, 0x006b, 0x0003, { 0x38, 0x83, 0x1d } }, /* 308 */ /* [303] */
	{ ACT_WRITE, 0x006b, 0x0003, { 0x39, 0xe2, 0x1d } }, /* 309 */ /* [304] */
	{ ACT_WRITE, 0x006b, 0x0003, { 0x3a, 0x23, 0x1e } }, /* 310 */ /* [305] */
	{ ACT_WRITE, 0x006b, 0x0003, { 0x3b, 0x82, 0x1e } }, /* 311 */ /* [306] */
	{ ACT_WRITE, 0x006b, 0x0003, { 0x3c, 0xc3, 0x1e } }, /* 312 */ /* [307] */
	{ ACT_WRITE, 0x006b, 0x0003, { 0x3d, 0x22, 0x1f } }, /* 313 */ /* [308] */
	{ ACT_WRITE, 0x006b, 0x0003, { 0x3e, 0x63, 0x1f } }, /* 314 */ /* [309] */
	{ ACT_WRITE, 0x006b, 0x0003, { 0x3f, 0xc1, 0x1f } }, /* 315 */ /* [310] */
	{ ACT_WRITE, 0x006a, 0x0001, { 0x00 } }, /* 316 */ /* [311] */
	{ ACT_WRITE, 0x0020, 0x0008, { 0x10, 0x42, 0x81, 0x19, 0xd3, 0xff, 0xa7, 0xff } }, /* 317 */ /* [312] */
	{ ACT_WRITE, 0x0028, 0x0008, { 0x87, 0x00, 0x87, 0x00, 0x8f, 0xff, 0xea, 0xff } }, /* 318 */ /* [313] */
	{ ACT_WRITE, 0x0010, 0x0002, { 0xb1, 0xb1 } }, /* 319 */ /* [314] */
	{ ACT_WRITE, 0x0092, 0x0001, { 0x03 } }, /* 320 */ /* [315] */
	{ ACT_WRITE, 0x0071, 0x0004, { 0x04, 0x0c, 0x05, 0x0f } }, /* 321 */ /* [316] */
	{ ACT_WRITE, 0x007b, 0x0006, { 0x00, 0xff, 0x00, 0xff, 0x00, 0xff } }, /* 322 */ /* [317] */
	{ ACT_WRITE, 0x00f8, 0x0001, { 0x00 } }, /* 323 */ /* [318] */
	{ ACT_WRITE, 0x0010, 0x0002, { 0xb1, 0xb1 } }, /* 324 */ /* [319] */
	{ ACT_WRITE, 0x0098, 0x0001, { 0x41 } }, /* 325 */ /* [320] */
	{ ACT_WRITE, 0x00e5, 0x0004, { 0x88, 0x12, 0x70, 0x01 } }, /* 326 */ /* [321] */
	{  ACT_READ, 0x00e8, 0x0001, { 0x00 } }, /* 327 */ /* [322] */
	{ ACT_WRITE, 0x00e5, 0x0004, { 0x88, 0x0d, 0x02, 0x01 } }, /* 328 */ /* [323] */
	{  ACT_READ, 0x00e8, 0x0001, { 0x00 } }, /* 329 */ /* [324] */
	{ ACT_WRITE, 0x00e5, 0x0004, { 0x88, 0x0f, 0x00, 0x01 } }, /* 330 */ /* [325] */
	{  ACT_READ, 0x00e8, 0x0001, { 0x00 } }, /* 331 */ /* [326] */
	{ ACT_WRITE, 0x00e5, 0x0008, { 0x88, 0x03, 0x71, 0x01, 0x88, 0x04, 0x00, 0x01 } }, /* 332 */ /* [327] */
	{  ACT_READ, 0x00e8, 0x0008, { 0x00, 0x88, 0x04, 0x00, 0x00, 0x01, 0x00, 0x00 } }, /* 333 */ /* [328] */
	{ ACT_WRITE, 0x00e5, 0x0004, { 0x88, 0x02, 0x10, 0x01 } }, /* 334 */ /* [329] */
	{  ACT_READ, 0x00e8, 0x0001, { 0x00 } }, /* 335 */ /* [330] */
	{ ACT_WRITE, 0x00e5, 0x0008, { 0x88, 0x00, 0x88, 0x01, 0x88, 0x01, 0x01, 0x01 } }, /* 336 */ /* [331] */
	{  ACT_READ, 0x00e8, 0x0008, { 0x00, 0x88, 0x01, 0x00, 0x00, 0x01, 0x00, 0x00 } }, /* 337 */ /* [332] */
	{ ACT_WRITE, 0x00e5, 0x0004, { 0x88, 0x0b, 0x00, 0x01 } }, /* 338 */ /* [333] */
	{  ACT_READ, 0x00e8, 0x0001, { 0x00 } }, /* 339 */ /* [334] */
	{ ACT_WRITE, 0x00e5, 0x0004, { 0x88, 0x0a, 0x0a, 0x01 } }, /* 340 */ /* [335] */
	{  ACT_READ, 0x00e8, 0x0001, { 0x00 } }, /* 341 */ /* [336] */
	{ ACT_WRITE, 0x00e5, 0x0008, { 0x88, 0x00, 0x08, 0x01, 0x88, 0x01, 0x00, 0x01 } }, /* 342 */ /* [337] */
	{  ACT_READ, 0x00e8, 0x0008, { 0x00, 0x88, 0x01, 0x00, 0x00, 0x01, 0x00, 0x00 } }, /* 343 */ /* [338] */
	{ ACT_WRITE, 0x00e5, 0x0004, { 0x88, 0x05, 0x01, 0x01 } }, /* 344 */ /* [339] */
	{  ACT_READ, 0x00e8, 0x0001, { 0x00 } }, /* 345 */ /* [340] */
	{  ACT_READ, 0x00c3, 0x0001, { 0x00 } }, /* 346 */ /* [341] */
	{ ACT_WRITE, 0x00e5, 0x0004, { 0xa1, 0x18, 0x00, 0x01 } }, /* 347 */ /* [342] */
	{  ACT_READ, 0x00e7, 0x0008, { 0xff, 0x02, 0x88, 0x01, 0x00, 0x00, 0x01, 0x00 } }, /* 348 */ /* [343] */
	{ ACT_WRITE, 0x00c0, 0x0001, { 0x01 } }, /* 349 */ /* [344] */
	{ ACT_WRITE, 0x00c3, 0x0001, { 0x00 } }, /* 350 */ /* [345] */
	{ ACT_WRITE, 0x00c0, 0x0001, { 0x00 } }, /* 351 */ /* [346] */
	{  ACT_READ, 0x0001, 0x0001, { 0x18 } }, /* 352 */ /* [347] */
	{ ACT_WRITE, 0x0008, 0x0008, { 0xff, 0xd8, 0xff, 0xdb, 0x00, 0x84, 0x00, 0x05 } }, /* 353 */ /* [348] */
	{ ACT_WRITE, 0x0008, 0x0008, { 0x03, 0x04, 0x04, 0x04, 0x03, 0x05, 0x04, 0x04 } }, /* 354 */ /* [349] */
	{ ACT_WRITE, 0x0008, 0x0008, { 0x04, 0x05, 0x05, 0x05, 0x06, 0x07, 0x0c, 0x08 } }, /* 355 */ /* [350] */
	{ ACT_WRITE, 0x0008, 0x0008, { 0x07, 0x07, 0x07, 0x07, 0x0f, 0x0b, 0x0b, 0x09 } }, /* 356 */ /* [351] */
	{ ACT_WRITE, 0x0008, 0x0008, { 0x0c, 0x11, 0x0f, 0x12, 0x12, 0x11, 0x0f, 0x11 } }, /* 357 */ /* [352] */
	{ ACT_WRITE, 0x0008, 0x0008, { 0x11, 0x13, 0x16, 0x1c, 0x17, 0x13, 0x14, 0x1a } }, /* 358 */ /* [353] */
	{ ACT_WRITE, 0x0008, 0x0008, { 0x15, 0x11, 0x11, 0x18, 0x21, 0x18, 0x1a, 0x1d } }, /* 359 */ /* [354] */
	{ ACT_WRITE, 0x0008, 0x0008, { 0x1d, 0x1f, 0x1f, 0x1f, 0x13, 0x17, 0x22, 0x24 } }, /* 360 */ /* [355] */
	{ ACT_WRITE, 0x0008, 0x0008, { 0x22, 0x1e, 0x24, 0x1c, 0x1e, 0x1f, 0x1e, 0x01 } }, /* 361 */ /* [356] */
	{ ACT_WRITE, 0x0008, 0x0008, { 0x05, 0x03, 0x04, 0x04, 0x04, 0x03, 0x05, 0x04 } }, /* 362 */ /* [357] */
	{ ACT_WRITE, 0x0008, 0x0008, { 0x04, 0x04, 0x05, 0x05, 0x05, 0x06, 0x07, 0x0c } }, /* 363 */ /* [358] */
	{ ACT_WRITE, 0x0008, 0x0008, { 0x08, 0x07, 0x07, 0x07, 0x07, 0x0f, 0x0b, 0x0b } }, /* 364 */ /* [359] */
	{ ACT_WRITE, 0x0008, 0x0008, { 0x09, 0x0c, 0x11, 0x0f, 0x12, 0x12, 0x11, 0x0f } }, /* 365 */ /* [360] */
	{ ACT_WRITE, 0x0008, 0x0008, { 0x11, 0x11, 0x13, 0x16, 0x1c, 0x17, 0x13, 0x14 } }, /* 366 */ /* [361] */
	{ ACT_WRITE, 0x0008, 0x0008, { 0x1a, 0x15, 0x11, 0x11, 0x18, 0x21, 0x18, 0x1a } }, /* 367 */ /* [362] */
	{ ACT_WRITE, 0x0008, 0x0008, { 0x1d, 0x1d, 0x1f, 0x1f, 0x1f, 0x13, 0x17, 0x22 } }, /* 368 */ /* [363] */
	{ ACT_WRITE, 0x0008, 0x0008, { 0x24, 0x22, 0x1e, 0x24, 0x1c, 0x1e, 0x1f, 0x1e } }, /* 369 */ /* [364] */
	{ ACT_WRITE, 0x0008, 0x0008, { 0xff, 0x20, 0x00, 0x1f, 0x02, 0x0c, 0x00, 0x00 } }, /* 370 */ /* [365] */
	{ ACT_WRITE, 0x0008, 0x0008, { 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x00 } }, /* 371 */ /* [366] */
	{ ACT_WRITE, 0x0008, 0x0008, { 0x11, 0x22, 0x00, 0x22, 0x22, 0x11, 0x22, 0x22 } }, /* 372 */ /* [367] */
	{ ACT_WRITE, 0x0008, 0x0008, { 0x11, 0x33, 0x33, 0x11, 0x44, 0x66, 0x22, 0x55 } }, /* 373 */ /* [368] */
	{ ACT_WRITE, 0x0008, 0x0008, { 0x66, 0xff, 0xdd, 0x00, 0x04, 0x00, 0x14, 0xff } }, /* 374 */ /* [369] */
	{ ACT_WRITE, 0x0008, 0x0008, { 0xc0, 0x00, 0x11, 0x08, 0x00, 0xf0, 0x01, 0x40 } }, /* 375 */ /* [370] */
	{ ACT_WRITE, 0x0008, 0x0008, { 0x03, 0x00, 0x21, 0x00, 0x01, 0x11, 0x01, 0x02 } }, /* 376 */ /* [371] */
	{ ACT_WRITE, 0x0008, 0x0008, { 0x11, 0x01, 0xff, 0xda, 0x00, 0x0c, 0x03, 0x00 } }, /* 377 */ /* [372] */
	{ ACT_WRITE, 0x0008, 0x0008, { 0x00, 0x01, 0x11, 0x02, 0x11, 0x00, 0x3f, 0x00 } }, /* 378 */ /* [373] */
	{ ACT_WRITE, 0x0008, 0x0002, { 0xff, 0xd9 } }, /* 379 */ /* [374] */
	{  ACT_READ, 0x0002, 0x0001, { 0x00 } }, /* 380 */ /* [375] */
	{ ACT_WRITE, 0x0055, 0x0001, { 0x14 } }, /* 381 */ /* [376] */
};

/*
 * init #2 coloer space i420 320x240
 */
initURB_t i420_init2[INIT2_URBS_NUM] = {
    /* [0] */
    { ACT_WRITE, 0x0000, 0x0001, { 0x00 } },
    { ACT_READ,  0x0002, 0x0001, { 0x07 } },
    { ACT_WRITE, 0x0053, 0x0001, { 0x00 } },
    { ACT_READ,  0x0002, 0x0001, { 0x07 } },
    { ACT_WRITE, 0x0053, 0x0001, { 0x00 } },
    { ACT_READ,  0x0002, 0x0001, { 0x07 } },
    { ACT_WRITE, 0x0053, 0x0001, { 0x00 } },
    { ACT_READ,  0x0002, 0x0001, { 0x07 } },
    { ACT_READ,  0x0001, 0x0001, { 0x18 } },
    { ACT_WRITE, 0x0008, 0x0008, { 0xff, 0xd8, 0xff, 0xdb, 0x00, 0x84, 0x00, 0x05 } },
    { ACT_WRITE, 0x0008, 0x0008, { 0x03, 0x04, 0x04, 0x04, 0x03, 0x05, 0x04, 0x04 } },
    { ACT_WRITE, 0x0008, 0x0008, { 0x04, 0x05, 0x05, 0x05, 0x06, 0x07, 0x0c, 0x08 } },
    { ACT_WRITE, 0x0008, 0x0008, { 0x07, 0x06, 0x06, 0x07, 0x0e, 0x0a, 0x0b, 0x08 } },
    { ACT_WRITE, 0x0008, 0x0008, { 0x0c, 0x11, 0x0f, 0x12, 0x12, 0x11, 0x0f, 0x10 } },
    { ACT_WRITE, 0x0008, 0x0008, { 0x10, 0x13, 0x15, 0x1b, 0x17, 0x13, 0x14, 0x19 } },
    { ACT_WRITE, 0x0008, 0x0008, { 0x14, 0x10, 0x10, 0x17, 0x20, 0x18, 0x19, 0x1c } },
    { ACT_WRITE, 0x0008, 0x0008, { 0x1d, 0x1e, 0x1e, 0x1e, 0x12, 0x17, 0x21, 0x23 } },
    { ACT_WRITE, 0x0008, 0x0008, { 0x21, 0x1d, 0x23, 0x1b, 0x1e, 0x1e, 0x1d, 0x01 } },
    { ACT_WRITE, 0x0008, 0x0008, { 0x05, 0x03, 0x04, 0x04, 0x04, 0x03, 0x05, 0x04 } },
    { ACT_WRITE, 0x0008, 0x0008, { 0x04, 0x04, 0x05, 0x05, 0x05, 0x06, 0x07, 0x0c } },
    { ACT_WRITE, 0x0008, 0x0008, { 0x08, 0x07, 0x06, 0x06, 0x07, 0x0e, 0x0a, 0x0b } },
    { ACT_WRITE, 0x0008, 0x0008, { 0x08, 0x0c, 0x11, 0x0f, 0x12, 0x12, 0x11, 0x0f } },
    { ACT_WRITE, 0x0008, 0x0008, { 0x10, 0x10, 0x13, 0x15, 0x1b, 0x17, 0x13, 0x14 } },
    { ACT_WRITE, 0x0008, 0x0008, { 0x19, 0x14, 0x10, 0x10, 0x17, 0x20, 0x18, 0x19 } },
    { ACT_WRITE, 0x0008, 0x0008, { 0x1c, 0x1d, 0x1e, 0x1e, 0x1e, 0x12, 0x17, 0x21 } },
    { ACT_WRITE, 0x0008, 0x0008, { 0x23, 0x21, 0x1d, 0x23, 0x1b, 0x1e, 0x1e, 0x1d } },
    { ACT_WRITE, 0x0008, 0x0002, { 0xff, 0xd9 } },
    { ACT_READ,  0x0002, 0x0001, { 0x00 } },
    { ACT_READ,  0x0053, 0x0001, { 0x00 } },
    { ACT_WRITE, 0x0054, 0x0001, { 0x02 } },
    { ACT_WRITE, 0x0054, 0x0001, { 0x01 } },
    { ACT_WRITE, 0x0000, 0x0001, { 0x94 } },
    { ACT_WRITE, 0x0053, 0x0001, { 0xc0 } },
    { ACT_READ,  0x0038, 0x0001, { 0x40 } },
    { ACT_READ,  0x0038, 0x0001, { 0x40 } },
    { ACT_READ,  0x001f, 0x0001, { 0x00 } },
    { ACT_WRITE, 0x00e5, 0x0004, { 0x88, 0x0b, 0xf0, 0x01 } },
    { ACT_READ,  0x00e8, 0x0001, { 0x00 } },
    { ACT_WRITE, 0x00e5, 0x0004, { 0x88, 0x05, 0x01, 0x01 } },
    { ACT_READ,  0x00e8, 0x0001, { 0x00 } },
    { ACT_READ,  0x0038, 0x0001, { 0x40 } },
    { ACT_READ,  0x0038, 0x0001, { 0x40 } },
    { ACT_READ,  0x001f, 0x0001, { 0x38 } },
    { ACT_WRITE, 0x0012, 0x0005, { 0x0a, 0x05, 0x07, 0x04, 0x19 } },
    { ACT_WRITE, 0x00e5, 0x0008, { 0x88, 0x00, 0x88, 0x01, 0x88, 0x01, 0x01, 0x01 } },
    { ACT_READ,  0x00e8, 0x0008, { 0x00, 0x88, 0x01, 0x00, 0x00, 0x01, 0x00, 0x00 } },
    { ACT_WRITE, 0x00e5, 0x0004, { 0x88, 0x0a, 0x0c, 0x01 } },
    { ACT_READ,  0x00e8, 0x0001, { 0x00 } },
    { ACT_WRITE, 0x009a, 0x0001, { 0x01 } },
    { ACT_WRITE, 0x00e5, 0x0004, { 0x88, 0x0b, 0xff, 0x01 } },
    { ACT_READ,  0x00e8, 0x0001, { 0x00 } },
    { ACT_WRITE, 0x00e5, 0x0004, { 0x88, 0x05, 0x01, 0x01 } },
    { ACT_READ,  0x00e8, 0x0001, { 0x00 } },
    { ACT_READ,  0x0038, 0x0001, { 0x40 } },
    { ACT_READ,  0x0038, 0x0001, { 0x40 } },
    { ACT_READ,  0x0038, 0x0001, { 0x40 } },
    { ACT_WRITE, 0x0070, 0x0001, { 0x03 } },
    { ACT_READ,  0x0038, 0x0001, { 0x40 } },
    { ACT_READ,  0x0038, 0x0001, { 0x40 } },
    { ACT_READ,  0x0075, 0x0008, { 0xd9, 0x9e, 0x02, 0xe6, 0x7d, 0x05, 0x00, 0xff } },
    { ACT_WRITE, 0x00e5, 0x0008, { 0x88, 0x03, 0x71, 0x01, 0x88, 0x04, 0x01, 0x01 } },
    { ACT_READ,  0x00e8, 0x0008, { 0x00, 0x88, 0x04, 0x00, 0x00, 0x01, 0x00, 0x00 } },
    { ACT_WRITE, 0x00e5, 0x0004, { 0x88, 0x05, 0x01, 0x01 } },
    { ACT_READ,  0x00e8, 0x0001, { 0x00 } },
    { ACT_WRITE, 0x0041, 0x0008, { 0xe1, 0xff, 0xf0, 0xff, 0xcd, 0xff, 0xc8, 0xff } },
    { ACT_WRITE, 0x0049, 0x0008, { 0xf7, 0xff, 0x82, 0xff, 0x0a, 0x02, 0xdb, 0x01 } },
    { ACT_WRITE, 0x0051, 0x0002, { 0x48, 0x03 } },
    { ACT_WRITE, 0x0010, 0x0002, { 0xb1, 0xb1 } },
    { ACT_WRITE, 0x0070, 0x0001, { 0x03 } },
    { ACT_READ,  0x0038, 0x0001, { 0x40 } },
    { ACT_READ,  0x0038, 0x0001, { 0x40 } },
    { ACT_READ,  0x0038, 0x0001, { 0x40 } },
    { ACT_READ,  0x0083, 0x0008, { 0x30, 0x5b, 0x35, 0x00, 0xf6, 0x8c, 0x2f, 0x00 } },
    { ACT_READ,  0x008b, 0x0008, { 0xa7, 0x5f, 0x32, 0x00, 0x00, 0x03, 0x00, 0x03 } },
    { ACT_READ,  0x0075, 0x0008, { 0xd7, 0x77, 0x02, 0xac, 0x34, 0x05, 0x00, 0xff } },
    { ACT_WRITE, 0x0041, 0x0008, { 0xdd, 0xff, 0xef, 0xff, 0xc5, 0xff, 0xc0, 0xff } },
    { ACT_WRITE, 0x0049, 0x0008, { 0xf5, 0xff, 0x72, 0xff, 0x48, 0x02, 0x20, 0x02 } },
    { ACT_WRITE, 0x0051, 0x0002, { 0xb4, 0x03 } },
    { ACT_WRITE, 0x0010, 0x0002, { 0xb1, 0xb1 } },
    { ACT_WRITE, 0x0070, 0x0001, { 0x03 } },
    { ACT_READ,  0x0038, 0x0001, { 0x40 } },
    { ACT_READ,  0x0038, 0x0001, { 0x40 } },
    { ACT_READ,  0x0038, 0x0001, { 0x40 } },
    { ACT_READ,  0x0075, 0x0008, { 0x14, 0x01, 0x03, 0x84, 0x5d, 0x06, 0x00, 0xff } },
    { ACT_WRITE, 0x0041, 0x0008, { 0xda, 0xff, 0xed, 0xff, 0xc0, 0xff, 0xba, 0xff } },
    { ACT_WRITE, 0x0049, 0x0008, { 0xf4, 0xff, 0x64, 0xff, 0x81, 0x02, 0x55, 0x02 } },
    { ACT_WRITE, 0x0051, 0x0002, { 0x10, 0x04 } },
    { ACT_WRITE, 0x0010, 0x0002, { 0xb1, 0xb1 } },
    { ACT_WRITE, 0x0070, 0x0001, { 0x03 } },
};
