pub mod assignees;
pub mod clone;
pub mod create;
pub mod delete;
pub mod fork;
pub mod info;
pub mod list;
pub mod migrate;

use clap::Subcommand;

use super::GeneralArgs;

/// Repository subcommands
#[derive(Subcommand, Debug)]
pub enum RepoArgs {
    Create(create::RepoCreateArgs),
    Clone(clone::RepoCloneArgs),
    Delete(delete::RepoDeleteArgs),
    Fork(fork::RepoForkArgs),
    Info(info::RepoInfoArgs),
    Assignees(assignees::RepoAssigneesArgs),
    Migrate(migrate::RepoMigrateArgs),
    List(list::RepoListArgs),
}

impl RepoArgs {
    pub async fn run(self, general_args: GeneralArgs) -> anyhow::Result<()> {
        match self {
            RepoArgs::Create(args) => args.run(general_args).await,
            RepoArgs::Clone(args) => args.run(general_args).await,
            RepoArgs::Delete(args) => args.run(general_args).await,
            RepoArgs::Fork(args) => args.run(general_args).await,
            RepoArgs::Info(args) => args.run(general_args).await,
            RepoArgs::Assignees(args) => args.run(general_args).await,
            RepoArgs::Migrate(args) => args.run(general_args).await,
            RepoArgs::List(args) => args.run(general_args).await,
        }
    }
}

/// parses a string of format OWNER/REPO
fn parse_owner_and_repo(owner_and_repo: &str) -> anyhow::Result<(String, String)> {
    owner_and_repo
        .split_once('/')
        .map(|(owner, repo)| (owner.to_owned(), repo.to_owned()))
        .ok_or_else(|| {
            anyhow::anyhow!(
                "Please provide the repository you want to clone in the format OWNER/REPO."
            )
        })
}
