/************************************
  
   Copyright 2008 Google Inc.

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.

 ************************************/

/** @file buffer_main.h
 *  @brief defines structure to hold command-line arguments and protypes
 *  some functions.
 *
 *  generated by cgener.  http://code.google.com/p/cgener/
 */

#ifdef __cplusplus
extern "C" {
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>

#ifndef BUFFER_MAIN_H
#define BUFFER_MAIN_H

/* user-defined things in arg table */
#include <crush/crush_version.h>
/* end user-defined things */

/** exit code to use when invoked with usage() or version(). */
#define EXIT_HELP 1
/** exit code to use when everything was okay. */
#define EXIT_OKAY 0
/** exit code to use when there was an i/o-related error. */
#define EXIT_FILE_ERR -1
/** exit code to use when there was an error allocating memory. */
#define EXIT_MEM_ERR -2

/** current version of the application. */
#define APPLICATION_VERSION ""CRUSH_PACKAGE_VERSION""
/** short description of what the app does. */
#define APPLICATION_DESCRIPTION "buffers all input and prints it out all at once."

/** structure to hold commandline options & arguments.
 */
struct cmdargs {
	int help;	/**< @brief print this message and exit */
	char *output;	/**< @brief specifies output file for writing */
	int append;	/**< @brief specifies if the output file should be appended to */
};


/** parses commandline arguments and puts the info into a cmdargs struct.
 * @param argc number of arguments
 * @param argv array of argument strings
 * @param args structure to hold the parsed options & arguments
 */
void parse_args ( int, char **, struct cmdargs *);

/** prints application help information.
 * @param bin application name as invoked on the commandline
 */
void usage ( char * );

/** @brief prints application version.
  */
void version ( void );

/** @brief beginning of primary application logic section called by main().
  * 
  * @param args contains the parsed cmd-line options & arguments.
  * @param argc number of cmd-line arguments.
  * @param argv list of cmd-line arguments
  * @param optind index of the first non-option cmd-line argument.
  * 
  * @return exit status for main() to return.
  */
int buffer( struct cmdargs *args, int argc, char *argv[], int optind );

#endif

#ifdef __cplusplus
}
#endif
