/************************************
     Copyright 2009 Google Inc.

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.

 ************************************/

/** @file usage.c
 *  @brief contains functions for parsing arguments and printing usage info.
 *
 *  generated by cgener.  http://code.google.com/p/cgener/
 */


#ifdef HAVE_CONFIG_H
# include <config.h>
#endif
#include "hashjoin_main.h"

/** prints application help information.
 * @param bin application name as invoked on the commandline
 */
void usage( char *bin ) {
  fprintf(stderr, "\nhashjoin: joins dimensional fields from a file into a data stream\n");
  fprintf(stderr, "\nusage: %s <options> [file ...] \n", bin);
  fprintf(stderr, "options:\n");
	fprintf(stderr, "  -h, --help           print this message and exit\n");
	fprintf(stderr, "  -V, --version        print version info and exit\n");
	fprintf(stderr, "  -d, --delim <delim>  input data field separator string\n");
	fprintf(stderr, "  -f, --dimension-file <dimension_file>\n                       the file containing dimensional data\n");
	fprintf(stderr, "  -D, --dimension-delim <dimension_delim>\n                       dimension file field separator string (if different from\n                       the data stream delimiter)\n");
	fprintf(stderr, "  -k, --data-keys <data_key_fields>\n                       a list of lookup key field indexes in the data stream\n");
	fprintf(stderr, "  -l, --lookup-keys <dimension_key_fields>\n                       a list of lookup key field indexes in the dimension file\n");
	fprintf(stderr, "  -K, --key-labels <key_labels>\n                       a list of lookup key field labels\n");
	fprintf(stderr, "  -j, --joined-fields <dimension_fields>\n                       a list of dimensional field indexes to add to the data\n");
	fprintf(stderr, "  -J, --joined-labels <dimension_field_labels>\n                       a list of dimensional field labels to add to the data\n");
	fprintf(stderr, "  -L, --label-dimensions <dimension_labels>\n                       output labels for added fields when the data stream has a\n                       header and the dimension file does not.\n");
	fprintf(stderr, "\nIf using labels, the input data stream and the dimensional file must use the\nsame field labels.");
	printf("\n\n");
	return;
} 

/* this won't be used outside of this file */
void init_cmdargs( struct cmdargs * );

#include <getopt.h>

/** long option structure list */
static struct option long_options[] = {
	{"help", no_argument, 0, 'h'},
	{"version", no_argument, 0, 'V'},
	{"delim", required_argument, 0, 'd'},
	{"dimension-file", required_argument, 0, 'f'},
	{"dimension-delim", required_argument, 0, 'D'},
	{"data-keys", required_argument, 0, 'k'},
	{"lookup-keys", required_argument, 0, 'l'},
	{"key-labels", required_argument, 0, 'K'},
	{"joined-fields", required_argument, 0, 'j'},
	{"joined-labels", required_argument, 0, 'J'},
	{"label-dimensions", required_argument, 0, 'L'},
	{0, 0, 0, 0}
};

/** parses commandline arguments and puts the info into a cmdargs struct.
 * @param argc number of arguments
 * @param argv array of argument strings
 * @param args structure to hold the parsed options & arguments
 */
void parse_args ( int argc, char **argv, struct cmdargs *args){
  int c, option_index=0;

  init_cmdargs(args);

  while( (c = getopt_long(argc, argv, "hVd:f:D:k:l:K:j:J:L:", long_options, &option_index)) != -1 ){
    switch (c) {
      case '0':
        if ( long_options[option_index].flag != 0 )
          break;
			case 'h':
				args->help = 1;
				break;
			case 'V':
				args->version = 1;
				break;
			case 'd':
				args->delim = optarg;
				break;
			case 'f':
				args->dimension_file = optarg;
				break;
			case 'D':
				args->dimension_delim = optarg;
				break;
			case 'k':
				args->data_key_fields = optarg;
				break;
			case 'l':
				args->dimension_key_fields = optarg;
				break;
			case 'K':
				args->key_labels = optarg;
				break;
			case 'j':
				args->dimension_fields = optarg;
				break;
			case 'J':
				args->dimension_field_labels = optarg;
				break;
			case 'L':
				args->dimension_labels = optarg;
				break;
			default: break;
		}
	}
	return;
}


/** @brief initializes all elements in the cmdargs struct to NULL or 0.
 *  @param args pointer to the argument structure to be cleared out.
 */
void init_cmdargs( struct cmdargs *args ){
  /* this set all pointers to null, int values to 0 */
  memset( args, 0, sizeof(struct cmdargs) );
}

/** @brief prints application version.
  */
void version ( void ){
  fprintf(stderr, "%s\n", APPLICATION_VERSION);
}

