/************************************
     Copyright 2008 Google Inc.

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.

 ************************************/

/** @file main.c
  * @brief just contains the main() function.
  *
  * generated by cgener.  http://code.google.com/p/cgener/
  */

#ifdef HAVE_CONFIG_H
# include <config.h>
#endif
#include "reorder_main.h"

/** @brief entry point into the application.
  * as this is a generated function, it just calls apropriate fucntions to
  * parse commandlines, may do some user-defined code from the argument table,
  * and calls user-defined function reorder(), which is where all the real
  * work will begin.
  * 
  * @param argc number of command-line arguments.
  * @param argv list of arguments.
  * 
  * @return 
  */
int main ( int argc, char *argv[] ){
  struct cmdargs args;

  parse_args ( argc, argv, &args );

  
	if ( args.help ){
		usage(argv[0]); exit(EXIT_HELP);
	}

	if ( args.version ){
		version(); exit(1);
	}


  return reorder( &args, argc, argv, optind );
}

