# How to setup OpenID client for login with defguard.

### Client creation

Add new client as admin on defguard OpenID Apps tab. Remember to add correct Redirect Uri(User will be redirected to this page with generated code).

### Authentication request

Set up your login with defguard button to redirect to authorization endpoint

```
http://defguard.teonite.net/openid/authorize?
client_id=<YOUR_CLIENT_ID> // Generated by defguard available on app detail page
&redirect_uri=<YOUR_REDIRECT_URI>  // Generated by defguard available on app detail page
&scope=openid profile phone email
&response_type=code
&state=<YOUR_STATE>
```

#### Note:

1. Client id and secret is generated by defguard after creating your app you can see it on app detail page
2. Scope must contain openid
3. Available scopes are profile(all available info from user profile) phone and email
4. Currently only supported response_type is code.
5. Redirect uri is url on which user will be redirected with generated pkce code (Redirect uri must match uri declared on client creation otherwise error will be returned)

#### Successful authenication response

```
HTTP/1.1 302 Found

Location: <YOUR_REDIRECT_URI>?
code=SplxlOBeZQQYbYS6WxSbIA
&state=af0ifjsldkj
```

### Exchange code for token

After receiving code from previous step you need to exchange it for token
on token endpoint defguard.tnt/api/v1/oauth/token

Request Header and Url:

```
Content-Type: application/x-www-form-urlencoded
POST defguard.tnt/api/v1/oauth/token
```

Request body:
Need to be form encoded
```
grant_type=authorization_code
&redirect_uri=<YOUR_REDIRECT_URI>
&code=<CODE_RECEIVED_IN_PREVIOUS_STEP>
```

#### Note:

1. Currently only supported grant_type is authorization_code
2. Code is your pkce code received in previous step

#### Successful Token Response

```
  HTTP/1.1 200 OK
  Content-Type: application/json
  Cache-Control: no-store
  Pragma: no-cache

  {
   "id_token": "eyJhbGciOiJSUzI1NiIsImtpZCI6IjFlOWdkazcifQ.ewogImlzc
     yI6ICJodHRwOi8vc2VydmVyLmV4YW1wbGUuY29tIiwKICJzdWIiOiAiMjQ4Mjg5
     NzYxMDAxIiwKICJhdWQiOiAiczZCaGRSa3F0MyIsCiAibm9uY2UiOiAibi0wUzZ
     fV3pBMk1qIiwKICJleHAiOiAxMzExMjgxOTcwLAogImlhdCI6IDEzMTEyODA5Nz
     AKfQ.ggW8hZ1EuVLuxNuuIJKX_V8a_OMXzR0EHR9R6jgdqrOOF4daGU96Sr_P6q
     Jp6IcmD3HP99Obi1PRs-cwh3LO-p146waJ8IhehcwL7F09JdijmBqkvPeB2T9CJ
     NqeGpe-gccMg4vfKjkM8FcGvnzZUN4_KSP0aAp1tOJ1zZwgjxqGByKHiOtX7Tpd
     QyHE5lcMiKPXfEIQILVq0pc_E2DzL7emopWoaoZTF_m0_N0YzFC6g6EJbOEoRoS
     K5hoDalrcvRYLSrQAZZKflyuVCyixEoV9GfNQC3_osjzw2PAithfubEEBLuVVk4
     XUVrWOLrLl0nx7RkKU8NXNHq-rvKMzqg"
  }
```
