/*
* point.h
* DIN Is Noise is copyright (c) 2006-2024 Jagannathan Sampath
* DIN Is Noise is released under GNU Public License 2.0
* For more information, please visit https://dinisnoise.org/
*/

#ifndef __point
#define __point

#include <math.h>

template <class T> struct point {
  T x, y;
  point (T a, T b) : x(a), y(b) {}
  point () : x(0), y(0) {}
  void operator() (T a, T b) {
    x = a;
    y = b;
  }
  int operator== (const point<T>& p) {
    return ( (x == p.x) && (y == p.y));
  }

	point& operator+= (const T& d) {
		x += d;
		y += d;
		return *this;
	}

	point& operator= (const T& d) {
		x = d;
		y = d;
		return *this;
	}

	point& operator*= (const point<T>& m) {
		x *= m.x;
		y *= m.y;
		return *this;
	}

	point& operator= (const point<T>& q) {
		x = q.x;
		y = q.y;
		return *this;
	}

  void rotate (point<T>& c, T angle) {
    T px = x - c.x, py = y - c.y;
    x = px * cos (angle) - py * sin (angle) + c.x;
    y = px * sin (angle) + py * cos (angle) + c.y;
  }

  void scale (point<T>& c, T sx, T sy) {
    float px = sx * (x - c.x), py = sy * (y - c.y);
    x = c.x + px;
    y = c.y + py;
  }

};

template <typename T> point<T> operator+ (const point<T>& p1, const point<T>& p2) {
	return point<T> (p1.x + p2.x, p1.y + p2.y);
}

template <typename T> struct pointinfo : point<T> {
  int pin;
  void init () { pin = 0;}
  pointinfo () { init(); }
  pointinfo (const point<T>& p) : point<T> (p.x, p.y) { init(); }
  pointinfo (T tx, T ty, int p = 0) :point<T> (tx, ty) { pin = p; }
};

#endif
