# Generated by Django 4.2.13 on 2024-06-21 14:55

from django.db import migrations, models
import django.db.models.deletion

import cms.models.settingmodels


def separate_page_treenode(apps, schema_editor):
    Page = apps.get_model('cms', 'Page')
    TreeNode = apps.get_model('cms', 'TreeNode')
    db_alias = schema_editor.connection.alias

    for page in Page.objects.using(db_alias).order_by("path"):
        page.node_deprecated = TreeNode.objects.create(
            depth=page.depth,
            path=page.path,
            site=page.site,
            numchild=page.numchild,
            parent=page.parent.node_deprecated if page.parent else None,
        )
        page.save()


class Migration(migrations.Migration):

    dependencies = [
        ('sites', '0002_alter_domain_unique'),
        ('cms', '0037_merge_page_treenode'),
    ]

    operations = [
        migrations.AlterField(
            model_name='page',
            name='site',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='djangocms_pages', to='sites.site', verbose_name='site'),
        ),
        migrations.RenameField(
            model_name='page',
            old_name='node',
            new_name='node_deprecated',
        ),
        migrations.AlterField(
            model_name='page',
            name='node_deprecated',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='cms_pages', to='cms.treenode'),
        ),
        migrations.RunPython(migrations.RunPython.noop, reverse_code=separate_page_treenode),
        migrations.RemoveField(
            model_name='page',
            name='node_deprecated',
        ),
        migrations.DeleteModel(
            name='TreeNode',
        ),
        migrations.AlterField(
            model_name="usersettings",
            name="clipboard",
            field=cms.models.settingmodels.PlaceholderForeignKey(
                blank=True,
                editable=False,
                null=True,
                on_delete=django.db.models.deletion.CASCADE,
                to="cms.placeholder",
            ),
        ),
    ]
