/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.bulk;

import java.io.IOException;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.Version;
import org.elasticsearch.action.DocWriteRequest;
import org.elasticsearch.action.DocWriteResponse;
import org.elasticsearch.action.delete.DeleteResponse;
import org.elasticsearch.action.index.IndexResponse;
import org.elasticsearch.action.update.UpdateResponse;
import org.elasticsearch.common.CheckedConsumer;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Streamable;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.StatusToXContentObject;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentFragment;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentParserUtils;
import org.elasticsearch.rest.RestStatus;

public class BulkItemResponse
implements Streamable,
StatusToXContentObject {
    private static final String _INDEX = "_index";
    private static final String _TYPE = "_type";
    private static final String _ID = "_id";
    private static final String STATUS = "status";
    private static final String ERROR = "error";
    private int id;
    private DocWriteRequest.OpType opType;
    private DocWriteResponse response;
    private Failure failure;

    @Override
    public RestStatus status() {
        return this.failure == null ? this.response.status() : this.failure.getStatus();
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.startObject(this.opType.getLowercase());
        if (this.failure == null) {
            this.response.innerToXContent(builder, params);
            builder.field(STATUS, this.response.status().getStatus());
        } else {
            builder.field(_INDEX, this.failure.getIndex());
            builder.field(_TYPE, this.failure.getType());
            builder.field(_ID, this.failure.getId());
            builder.field(STATUS, this.failure.getStatus().getStatus());
            builder.startObject(ERROR);
            ElasticsearchException.generateThrowableXContent(builder, params, this.failure.getCause());
            builder.endObject();
        }
        builder.endObject();
        builder.endObject();
        return builder;
    }

    public static BulkItemResponse fromXContent(XContentParser parser, int id) throws IOException {
        BulkItemResponse bulkItemResponse;
        XContentParserUtils.ensureExpectedToken(XContentParser.Token.START_OBJECT, parser.currentToken(), parser::getTokenLocation);
        XContentParser.Token token = parser.nextToken();
        XContentParserUtils.ensureExpectedToken(XContentParser.Token.FIELD_NAME, token, parser::getTokenLocation);
        String currentFieldName = parser.currentName();
        token = parser.nextToken();
        DocWriteRequest.OpType opType = DocWriteRequest.OpType.fromString(currentFieldName);
        XContentParserUtils.ensureExpectedToken(XContentParser.Token.START_OBJECT, token, parser::getTokenLocation);
        DocWriteResponse.Builder builder = null;
        CheckedConsumer itemParser = null;
        if (opType == DocWriteRequest.OpType.INDEX || opType == DocWriteRequest.OpType.CREATE) {
            IndexResponse.Builder indexResponseBuilder = new IndexResponse.Builder();
            builder = indexResponseBuilder;
            itemParser = indexParser -> IndexResponse.parseXContentFields(indexParser, indexResponseBuilder);
        } else if (opType == DocWriteRequest.OpType.UPDATE) {
            UpdateResponse.Builder updateResponseBuilder = new UpdateResponse.Builder();
            builder = updateResponseBuilder;
            itemParser = updateParser -> UpdateResponse.parseXContentFields(updateParser, updateResponseBuilder);
        } else if (opType == DocWriteRequest.OpType.DELETE) {
            DeleteResponse.Builder deleteResponseBuilder = new DeleteResponse.Builder();
            builder = deleteResponseBuilder;
            itemParser = deleteParser -> DeleteResponse.parseXContentFields(deleteParser, deleteResponseBuilder);
        } else {
            XContentParserUtils.throwUnknownField(currentFieldName, parser.getTokenLocation());
        }
        RestStatus status = null;
        ElasticsearchException exception = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
            }
            if (ERROR.equals(currentFieldName)) {
                if (token != XContentParser.Token.START_OBJECT) continue;
                exception = ElasticsearchException.fromXContent(parser);
                continue;
            }
            if (STATUS.equals(currentFieldName)) {
                if (token != XContentParser.Token.VALUE_NUMBER) continue;
                status = RestStatus.fromCode(parser.intValue());
                continue;
            }
            itemParser.accept(parser);
        }
        XContentParserUtils.ensureExpectedToken(XContentParser.Token.END_OBJECT, token, parser::getTokenLocation);
        token = parser.nextToken();
        XContentParserUtils.ensureExpectedToken(XContentParser.Token.END_OBJECT, token, parser::getTokenLocation);
        if (exception != null) {
            Failure failure = new Failure(builder.getShardId().getIndexName(), builder.getType(), builder.getId(), (Exception)exception, status);
            bulkItemResponse = new BulkItemResponse(id, opType, failure);
        } else {
            bulkItemResponse = new BulkItemResponse(id, opType, builder.build());
        }
        return bulkItemResponse;
    }

    BulkItemResponse() {
    }

    public BulkItemResponse(int id, DocWriteRequest.OpType opType, DocWriteResponse response) {
        this.id = id;
        this.response = response;
        this.opType = opType;
    }

    public BulkItemResponse(int id, DocWriteRequest.OpType opType, Failure failure) {
        this.id = id;
        this.opType = opType;
        this.failure = failure;
    }

    public int getItemId() {
        return this.id;
    }

    public DocWriteRequest.OpType getOpType() {
        return this.opType;
    }

    public String getIndex() {
        if (this.failure != null) {
            return this.failure.getIndex();
        }
        return this.response.getIndex();
    }

    public String getType() {
        if (this.failure != null) {
            return this.failure.getType();
        }
        return this.response.getType();
    }

    public String getId() {
        if (this.failure != null) {
            return this.failure.getId();
        }
        return this.response.getId();
    }

    public long getVersion() {
        if (this.failure != null) {
            return -1L;
        }
        return this.response.getVersion();
    }

    public <T extends DocWriteResponse> T getResponse() {
        return (T)this.response;
    }

    public boolean isFailed() {
        return this.failure != null;
    }

    public String getFailureMessage() {
        if (this.failure != null) {
            return this.failure.getMessage();
        }
        return null;
    }

    public Failure getFailure() {
        return this.failure;
    }

    public static BulkItemResponse readBulkItem(StreamInput in) throws IOException {
        BulkItemResponse response = new BulkItemResponse();
        response.readFrom(in);
        return response;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        this.id = in.readVInt();
        this.opType = in.getVersion().onOrAfter(Version.V_5_3_0) ? DocWriteRequest.OpType.fromId(in.readByte()) : DocWriteRequest.OpType.fromString(in.readString());
        byte type = in.readByte();
        if (type == 0) {
            this.response = new IndexResponse();
            this.response.readFrom(in);
        } else if (type == 1) {
            this.response = new DeleteResponse();
            this.response.readFrom(in);
        } else if (type == 3) {
            this.response = new UpdateResponse();
            this.response.readFrom(in);
        }
        if (in.readBoolean()) {
            this.failure = new Failure(in);
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVInt(this.id);
        if (out.getVersion().onOrAfter(Version.V_5_3_0)) {
            out.writeByte(this.opType.getId());
        } else {
            out.writeString(this.opType.getLowercase());
        }
        if (this.response == null) {
            out.writeByte((byte)2);
        } else {
            if (this.response instanceof IndexResponse) {
                out.writeByte((byte)0);
            } else if (this.response instanceof DeleteResponse) {
                out.writeByte((byte)1);
            } else if (this.response instanceof UpdateResponse) {
                out.writeByte((byte)3);
            }
            this.response.writeTo(out);
        }
        if (this.failure == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            this.failure.writeTo(out);
        }
    }

    public static class Failure
    implements Writeable,
    ToXContentFragment {
        public static final String INDEX_FIELD = "index";
        public static final String TYPE_FIELD = "type";
        public static final String ID_FIELD = "id";
        public static final String CAUSE_FIELD = "cause";
        public static final String STATUS_FIELD = "status";
        private final String index;
        private final String type;
        private final String id;
        private final Exception cause;
        private final RestStatus status;
        private final long seqNo;
        private final boolean aborted;
        public static ConstructingObjectParser<Failure, Void> PARSER = new ConstructingObjectParser("bulk_failures", true, a -> new Failure((String)a[0], (String)a[1], (String)a[2], (Exception)a[3], RestStatus.fromCode((Integer)a[4])));

        public Failure(String index, String type, String id, Exception cause) {
            this(index, type, id, cause, ExceptionsHelper.status(cause), -2L, false);
        }

        public Failure(String index, String type, String id, Exception cause, boolean aborted) {
            this(index, type, id, cause, ExceptionsHelper.status(cause), -2L, aborted);
        }

        public Failure(String index, String type, String id, Exception cause, RestStatus status) {
            this(index, type, id, cause, status, -2L, false);
        }

        public Failure(String index, String type, String id, Exception cause, long seqNo) {
            this(index, type, id, cause, ExceptionsHelper.status(cause), seqNo, false);
        }

        public Failure(String index, String type, String id, Exception cause, RestStatus status, long seqNo, boolean aborted) {
            this.index = index;
            this.type = type;
            this.id = id;
            this.cause = cause;
            this.status = status;
            this.seqNo = seqNo;
            this.aborted = aborted;
        }

        public Failure(StreamInput in) throws IOException {
            this.index = in.readString();
            this.type = in.readString();
            this.id = in.readOptionalString();
            this.cause = in.readException();
            this.status = ExceptionsHelper.status(this.cause);
            this.seqNo = in.getVersion().onOrAfter(Version.V_6_0_0_alpha1) ? in.readZLong() : -2L;
            this.aborted = Failure.supportsAbortedFlag(in.getVersion()) ? in.readBoolean() : false;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.getIndex());
            out.writeString(this.getType());
            out.writeOptionalString(this.getId());
            out.writeException(this.getCause());
            if (out.getVersion().onOrAfter(Version.V_6_0_0_alpha1)) {
                out.writeZLong(this.getSeqNo());
            }
            if (Failure.supportsAbortedFlag(out.getVersion())) {
                out.writeBoolean(this.aborted);
            }
        }

        private static boolean supportsAbortedFlag(Version version) {
            return version.after(Version.V_6_0_0_beta2) || version.major == 5 && version.onOrAfter(Version.V_5_5_3);
        }

        public String getIndex() {
            return this.index;
        }

        public String getType() {
            return this.type;
        }

        public String getId() {
            return this.id;
        }

        public String getMessage() {
            return this.cause.toString();
        }

        public RestStatus getStatus() {
            return this.status;
        }

        public Exception getCause() {
            return this.cause;
        }

        public long getSeqNo() {
            return this.seqNo;
        }

        public boolean isAborted() {
            return this.aborted;
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.field(INDEX_FIELD, this.index);
            builder.field(TYPE_FIELD, this.type);
            if (this.id != null) {
                builder.field(ID_FIELD, this.id);
            }
            builder.startObject(CAUSE_FIELD);
            ElasticsearchException.generateThrowableXContent(builder, params, this.cause);
            builder.endObject();
            builder.field("status", this.status.getStatus());
            return builder;
        }

        public static Failure fromXContent(XContentParser parser) {
            return PARSER.apply(parser, null);
        }

        public String toString() {
            return Strings.toString(this);
        }

        static {
            PARSER.declareString(ConstructingObjectParser.constructorArg(), new ParseField(INDEX_FIELD, new String[0]));
            PARSER.declareString(ConstructingObjectParser.constructorArg(), new ParseField(TYPE_FIELD, new String[0]));
            PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), new ParseField(ID_FIELD, new String[0]));
            PARSER.declareObject(ConstructingObjectParser.constructorArg(), (p, c) -> ElasticsearchException.fromXContent(p), new ParseField(CAUSE_FIELD, new String[0]));
            PARSER.declareInt(ConstructingObjectParser.constructorArg(), new ParseField("status", new String[0]));
        }
    }
}

