/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.similarity;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.FieldInvertState;
import org.apache.lucene.index.Fields;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafMetaData;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.PointValues;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.index.StoredFieldVisitor;
import org.apache.lucene.index.Terms;
import org.apache.lucene.search.CollectionStatistics;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.TermStatistics;
import org.apache.lucene.search.similarities.BM25Similarity;
import org.apache.lucene.search.similarities.BooleanSimilarity;
import org.apache.lucene.search.similarities.ClassicSimilarity;
import org.apache.lucene.search.similarities.PerFieldSimilarityWrapper;
import org.apache.lucene.search.similarities.Similarity;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.Version;
import org.elasticsearch.common.TriFunction;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.AbstractIndexComponent;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.similarity.ScriptedSimilarityProvider;
import org.elasticsearch.index.similarity.SimilarityProvider;
import org.elasticsearch.index.similarity.SimilarityProviders;
import org.elasticsearch.script.ScriptService;

public final class SimilarityService
extends AbstractIndexComponent {
    private static final DeprecationLogger DEPRECATION_LOGGER = new DeprecationLogger(LogManager.getLogger(SimilarityService.class));
    public static final String DEFAULT_SIMILARITY = "BM25";
    private static final String CLASSIC_SIMILARITY = "classic";
    private static final Map<String, Function<Version, Supplier<Similarity>>> DEFAULTS;
    public static final Map<String, TriFunction<Settings, Version, ScriptService, Similarity>> BUILT_IN;
    private final Similarity defaultSimilarity;
    private final Map<String, Supplier<Similarity>> similarities;

    public SimilarityService(IndexSettings indexSettings, ScriptService scriptService, Map<String, TriFunction<Settings, Version, ScriptService, Similarity>> similarities) {
        super(indexSettings);
        HashMap<String, Supplier<Similarity>> providers = new HashMap<String, Supplier<Similarity>>(similarities.size());
        Map<String, Settings> similaritySettings = this.indexSettings.getSettings().getGroups("index.similarity");
        for (Map.Entry<String, Settings> entry : similaritySettings.entrySet()) {
            String name = entry.getKey();
            if (BUILT_IN.containsKey(name) && indexSettings.getIndexVersionCreated().onOrAfter(Version.V_5_0_0_alpha1)) {
                throw new IllegalArgumentException("Cannot redefine built-in Similarity [" + name + "]");
            }
            Settings providerSettings = entry.getValue();
            String typeName = providerSettings.get("type");
            if (typeName == null) {
                throw new IllegalArgumentException("Similarity [" + name + "] must have an associated type");
            }
            if (!(similarities.containsKey(typeName) || BUILT_IN.containsKey(typeName))) {
                throw new IllegalArgumentException("Unknown Similarity type [" + typeName + "] for [" + name + "]");
            }
            TriFunction<Settings, Version, ScriptService, Similarity> defaultFactory = BUILT_IN.get(typeName);
            TriFunction<Settings, Version, ScriptService, Similarity> factory = similarities.getOrDefault(typeName, defaultFactory);
            Similarity similarity = factory.apply(providerSettings, indexSettings.getIndexVersionCreated(), scriptService);
            SimilarityService.validateSimilarity(indexSettings.getIndexVersionCreated(), similarity);
            providers.put(name, () -> similarity);
        }
        for (Map.Entry<String, Object> entry : DEFAULTS.entrySet()) {
            providers.put(entry.getKey(), (Supplier)((Function)entry.getValue()).apply(indexSettings.getIndexVersionCreated()));
        }
        this.similarities = providers;
        Similarity similarity = this.defaultSimilarity = providers.get("default") != null ? (Similarity)((Supplier)providers.get("default")).get() : (Similarity)((Supplier)providers.get(DEFAULT_SIMILARITY)).get();
        if (providers.get("base") != null) {
            DEPRECATION_LOGGER.deprecated("The [base] similarity is ignored since query normalization and coords have been removed", new Object[0]);
        }
    }

    public Similarity similarity(MapperService mapperService) {
        return mapperService != null ? new PerFieldSimilarity(this.defaultSimilarity, mapperService) : this.defaultSimilarity;
    }

    public SimilarityProvider getSimilarity(String name) {
        Supplier<Similarity> sim = this.similarities.get(name);
        if (sim == null) {
            return null;
        }
        return new SimilarityProvider(name, sim.get());
    }

    Similarity getDefaultSimilarity() {
        return this.defaultSimilarity;
    }

    static void validateSimilarity(Version indexCreatedVersion, Similarity similarity) {
        try {
            SimilarityService.validateScoresArePositive(indexCreatedVersion, similarity);
            SimilarityService.validateScoresDoNotDecreaseWithFreq(indexCreatedVersion, similarity);
            SimilarityService.validateScoresDoNotIncreaseWithNorm(indexCreatedVersion, similarity);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private static void validateScoresArePositive(Version indexCreatedVersion, Similarity similarity) throws IOException {
        CollectionStatistics collectionStats = new CollectionStatistics("some_field", 1200L, 1100L, 3000L, 2000L);
        TermStatistics termStats = new TermStatistics(new BytesRef("some_value"), 100L, 130L);
        Similarity.SimWeight simWeight = similarity.computeWeight(2.0f, collectionStats, termStats);
        FieldInvertState state = new FieldInvertState(indexCreatedVersion.luceneVersion.major, "some_field", 20, 20, 0, 50);
        long norm = similarity.computeNorm(state);
        SingleNormLeafReader reader = new SingleNormLeafReader(norm);
        Similarity.SimScorer scorer = similarity.simScorer(simWeight, reader.getContext());
        for (int freq = 1; freq <= 10; ++freq) {
            float score = scorer.score(0, freq);
            if (!(score < 0.0f)) continue;
            DEPRECATION_LOGGER.deprecated("Similarities should not return negative scores:\n" + scorer.explain(0, Explanation.match((float)freq, "term freq", new Explanation[0])), new Object[0]);
            break;
        }
    }

    private static void validateScoresDoNotDecreaseWithFreq(Version indexCreatedVersion, Similarity similarity) throws IOException {
        CollectionStatistics collectionStats = new CollectionStatistics("some_field", 1200L, 1100L, 3000L, 2000L);
        TermStatistics termStats = new TermStatistics(new BytesRef("some_value"), 100L, 130L);
        Similarity.SimWeight simWeight = similarity.computeWeight(2.0f, collectionStats, termStats);
        FieldInvertState state = new FieldInvertState(indexCreatedVersion.luceneVersion.major, "some_field", 20, 20, 0, 50);
        long norm = similarity.computeNorm(state);
        SingleNormLeafReader reader = new SingleNormLeafReader(norm);
        Similarity.SimScorer scorer = similarity.simScorer(simWeight, reader.getContext());
        float previousScore = Float.NEGATIVE_INFINITY;
        for (int freq = 1; freq <= 10; ++freq) {
            float score = scorer.score(0, freq);
            if (score < previousScore) {
                DEPRECATION_LOGGER.deprecated("Similarity scores should not decrease when term frequency increases:\n" + scorer.explain(0, Explanation.match((float)(freq - 1), "term freq", new Explanation[0])) + "\n" + scorer.explain(0, Explanation.match((float)freq, "term freq", new Explanation[0])), new Object[0]);
                break;
            }
            previousScore = score;
        }
    }

    private static void validateScoresDoNotIncreaseWithNorm(Version indexCreatedVersion, Similarity similarity) throws IOException {
        FieldInvertState state;
        long norm;
        CollectionStatistics collectionStats = new CollectionStatistics("some_field", 1200L, 1100L, 3000L, 2000L);
        TermStatistics termStats = new TermStatistics(new BytesRef("some_value"), 100L, 130L);
        Similarity.SimWeight simWeight = similarity.computeWeight(2.0f, collectionStats, termStats);
        Similarity.SimScorer previousScorer = null;
        long previousNorm = 0L;
        float previousScore = Float.POSITIVE_INFINITY;
        for (int length = 1; length <= 10 && Long.compareUnsigned(previousNorm, norm = similarity.computeNorm(state = new FieldInvertState(indexCreatedVersion.luceneVersion.major, "some_field", length, length, 0, 50))) <= 0; ++length) {
            SingleNormLeafReader reader = new SingleNormLeafReader(norm);
            Similarity.SimScorer scorer = similarity.simScorer(simWeight, reader.getContext());
            float score = scorer.score(0, 1.0f);
            if (score > previousScore) {
                DEPRECATION_LOGGER.deprecated("Similarity scores should not increase when norm increases:\n" + previousScorer.explain(0, Explanation.match(1.0f, "term freq", new Explanation[0])) + "\n" + scorer.explain(0, Explanation.match(1.0f, "term freq", new Explanation[0])), new Object[0]);
                break;
            }
            previousScorer = scorer;
            previousScore = score;
            previousNorm = norm;
        }
    }

    static {
        HashMap<String, Function<Version, Supplier>> defaults = new HashMap<String, Function<Version, Supplier>>();
        defaults.put(CLASSIC_SIMILARITY, version -> {
            ClassicSimilarity similarity = SimilarityProviders.createClassicSimilarity(Settings.EMPTY, version);
            return () -> {
                DEPRECATION_LOGGER.deprecated("The [classic] similarity is now deprecated in favour of BM25, which is generally accepted as a better alternative. Use the [BM25] similarity or build a custom [scripted] similarity instead.", new Object[0]);
                return similarity;
            };
        });
        defaults.put(DEFAULT_SIMILARITY, version -> {
            BM25Similarity similarity = SimilarityProviders.createBM25Similarity(Settings.EMPTY, version);
            return () -> similarity;
        });
        defaults.put("boolean", version -> {
            BooleanSimilarity similarity = new BooleanSimilarity();
            return () -> similarity;
        });
        HashMap<String, TriFunction<Settings, Version, ScriptService, Similarity>> builtIn = new HashMap<String, TriFunction<Settings, Version, ScriptService, Similarity>>();
        builtIn.put(CLASSIC_SIMILARITY, (settings, version, script) -> {
            DEPRECATION_LOGGER.deprecated("The [classic] similarity is now deprecated in favour of BM25, which is generally accepted as a better alternative. Use the [BM25] similarity or build a custom [scripted] similarity instead.", new Object[0]);
            return SimilarityProviders.createClassicSimilarity(settings, version);
        });
        builtIn.put(DEFAULT_SIMILARITY, (settings, version, scriptService) -> SimilarityProviders.createBM25Similarity(settings, version));
        builtIn.put("boolean", (settings, version, scriptService) -> SimilarityProviders.createBooleanSimilarity(settings, version));
        builtIn.put("DFR", (settings, version, scriptService) -> SimilarityProviders.createDfrSimilarity(settings, version));
        builtIn.put("IB", (settings, version, scriptService) -> SimilarityProviders.createIBSimilarity(settings, version));
        builtIn.put("LMDirichlet", (settings, version, scriptService) -> SimilarityProviders.createLMDirichletSimilarity(settings, version));
        builtIn.put("LMJelinekMercer", (settings, version, scriptService) -> SimilarityProviders.createLMJelinekMercerSimilarity(settings, version));
        builtIn.put("DFI", (settings, version, scriptService) -> SimilarityProviders.createDfiSimilarity(settings, version));
        builtIn.put("scripted", new ScriptedSimilarityProvider());
        DEFAULTS = Collections.unmodifiableMap(defaults);
        BUILT_IN = Collections.unmodifiableMap(builtIn);
    }

    private static class SingleNormLeafReader
    extends LeafReader {
        private final long norm;

        SingleNormLeafReader(long norm) {
            this.norm = norm;
        }

        @Override
        public IndexReader.CacheHelper getCoreCacheHelper() {
            return null;
        }

        @Override
        public Terms terms(String field) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public NumericDocValues getNumericDocValues(String field) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public BinaryDocValues getBinaryDocValues(String field) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public SortedDocValues getSortedDocValues(String field) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public SortedNumericDocValues getSortedNumericDocValues(String field) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public SortedSetDocValues getSortedSetDocValues(String field) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public NumericDocValues getNormValues(String field) throws IOException {
            return new NumericDocValues(){
                int doc = -1;

                @Override
                public long longValue() throws IOException {
                    return norm;
                }

                @Override
                public boolean advanceExact(int target) throws IOException {
                    this.doc = target;
                    return true;
                }

                @Override
                public int docID() {
                    return this.doc;
                }

                @Override
                public int nextDoc() throws IOException {
                    return this.advance(this.doc + 1);
                }

                @Override
                public int advance(int target) throws IOException {
                    if (target == 0) {
                        this.doc = 0;
                        return 0;
                    }
                    this.doc = Integer.MAX_VALUE;
                    return Integer.MAX_VALUE;
                }

                @Override
                public long cost() {
                    return 1L;
                }
            };
        }

        @Override
        public FieldInfos getFieldInfos() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Bits getLiveDocs() {
            return null;
        }

        @Override
        public PointValues getPointValues(String field) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void checkIntegrity() throws IOException {
        }

        @Override
        public LeafMetaData getMetaData() {
            return new LeafMetaData(org.apache.lucene.util.Version.LATEST.major, org.apache.lucene.util.Version.LATEST, null);
        }

        @Override
        public Fields getTermVectors(int docID) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public int numDocs() {
            return 1;
        }

        @Override
        public int maxDoc() {
            return 1;
        }

        @Override
        public void document(int docID, StoredFieldVisitor visitor) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        protected void doClose() throws IOException {
        }

        @Override
        public IndexReader.CacheHelper getReaderCacheHelper() {
            throw new UnsupportedOperationException();
        }
    }

    static class PerFieldSimilarity
    extends PerFieldSimilarityWrapper {
        private final Similarity defaultSimilarity;
        private final MapperService mapperService;

        PerFieldSimilarity(Similarity defaultSimilarity, MapperService mapperService) {
            this.defaultSimilarity = defaultSimilarity;
            this.mapperService = mapperService;
        }

        @Override
        public Similarity get(String name) {
            MappedFieldType fieldType = this.mapperService.fullName(name);
            return fieldType != null && fieldType.similarity() != null ? fieldType.similarity().get() : this.defaultSimilarity;
        }
    }
}

