/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.proto;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.xpack.sql.proto.ProtoUtils;

public class ColumnInfo
implements ToXContentObject {
    private static final ConstructingObjectParser<ColumnInfo, Void> PARSER = new ConstructingObjectParser("column_info", true, objects -> new ColumnInfo(objects[0] == null ? "" : (String)objects[0], (String)objects[1], (String)objects[2], (Integer)objects[3]));
    private static final ParseField TABLE = new ParseField("table", new String[0]);
    private static final ParseField NAME = new ParseField("name", new String[0]);
    private static final ParseField ES_TYPE = new ParseField("type", new String[0]);
    private static final ParseField DISPLAY_SIZE = new ParseField("display_size", new String[0]);
    private final String table;
    private final String name;
    private final String esType;
    private final Integer displaySize;

    public ColumnInfo(String table, String name, String esType, Integer displaySize) {
        this.table = table;
        this.name = name;
        this.esType = esType;
        this.displaySize = displaySize;
    }

    public ColumnInfo(String table, String name, String esType) {
        this.table = table;
        this.name = name;
        this.esType = esType;
        this.displaySize = null;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.table != null && !this.table.isEmpty()) {
            builder.field("table", this.table);
        }
        builder.field("name", this.name);
        builder.field("type", this.esType);
        if (this.displaySize != null) {
            builder.field("display_size", this.displaySize);
        }
        return builder.endObject();
    }

    public static ColumnInfo fromXContent(XContentParser parser) {
        return PARSER.apply(parser, null);
    }

    public String table() {
        return this.table;
    }

    public String name() {
        return this.name;
    }

    public String esType() {
        return this.esType;
    }

    public int displaySize() {
        return this.displaySize;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ColumnInfo that = (ColumnInfo)o;
        return this.displaySize == that.displaySize && Objects.equals(this.table, that.table) && Objects.equals(this.name, that.name) && Objects.equals(this.esType, that.esType);
    }

    public int hashCode() {
        return Objects.hash(this.table, this.name, this.esType, this.displaySize);
    }

    public String toString() {
        return ProtoUtils.toString(this);
    }

    static {
        PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), TABLE);
        PARSER.declareString(ConstructingObjectParser.constructorArg(), NAME);
        PARSER.declareString(ConstructingObjectParser.constructorArg(), ES_TYPE);
        PARSER.declareInt(ConstructingObjectParser.optionalConstructorArg(), DISPLAY_SIZE);
    }
}

