/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security;

import java.io.IOException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.xpack.core.security.authc.Authentication;
import org.elasticsearch.xpack.core.security.user.User;

public final class UserSettings {
    private final Logger logger = LogManager.getLogger(UserSettings.class);
    private final ThreadContext threadContext;

    UserSettings(ThreadContext threadContext) {
        this.threadContext = threadContext;
    }

    public User getUser() {
        Authentication authentication = this.getAuthentication();
        return authentication == null ? null : authentication.getUser();
    }

    public Authentication getAuthentication() {
        try {
            return Authentication.readFromContext(this.threadContext);
        }
        catch (IOException e) {
            this.logger.error("failed to read authentication", (Throwable)e);
            return null;
        }
    }
}

