/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.job.persistence;

import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.TermsQueryBuilder;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.sort.FieldSortBuilder;
import org.elasticsearch.search.sort.SortBuilder;
import org.elasticsearch.search.sort.SortBuilders;
import org.elasticsearch.search.sort.SortOrder;
import org.elasticsearch.xpack.core.ml.job.results.AnomalyRecord;
import org.elasticsearch.xpack.core.ml.job.results.Result;
import org.elasticsearch.xpack.ml.job.persistence.ResultsFilterBuilder;

public final class RecordsQueryBuilder {
    public static final int DEFAULT_SIZE = 100;
    private static final List<String> SECONDARY_SORT = Arrays.asList(AnomalyRecord.RECORD_SCORE.getPreferredName(), AnomalyRecord.OVER_FIELD_VALUE.getPreferredName(), AnomalyRecord.PARTITION_FIELD_VALUE.getPreferredName(), AnomalyRecord.BY_FIELD_VALUE.getPreferredName(), AnomalyRecord.FIELD_NAME.getPreferredName(), AnomalyRecord.FUNCTION.getPreferredName());
    private int from = 0;
    private int size = 100;
    private boolean includeInterim = false;
    private String sortField;
    private boolean sortDescending = true;
    private double recordScore = 0.0;
    private String start;
    private String end;
    private Date timestamp;

    public RecordsQueryBuilder from(int from) {
        this.from = from;
        return this;
    }

    public RecordsQueryBuilder size(int size) {
        this.size = size;
        return this;
    }

    public RecordsQueryBuilder epochStart(String startTime) {
        this.start = startTime;
        return this;
    }

    public RecordsQueryBuilder epochEnd(String endTime) {
        this.end = endTime;
        return this;
    }

    public RecordsQueryBuilder includeInterim(boolean include) {
        this.includeInterim = include;
        return this;
    }

    public RecordsQueryBuilder sortField(String fieldname) {
        this.sortField = fieldname;
        return this;
    }

    public RecordsQueryBuilder sortDescending(boolean sortDescending) {
        this.sortDescending = sortDescending;
        return this;
    }

    public RecordsQueryBuilder recordScore(double recordScore) {
        this.recordScore = recordScore;
        return this;
    }

    public RecordsQueryBuilder timestamp(Date timestamp) {
        this.timestamp = timestamp;
        return this;
    }

    public SearchSourceBuilder build() {
        QueryBuilder query = new ResultsFilterBuilder().timeRange(Result.TIMESTAMP.getPreferredName(), this.start, this.end).score(AnomalyRecord.RECORD_SCORE.getPreferredName(), this.recordScore).interim(this.includeInterim).build();
        FieldSortBuilder sb = this.sortField != null ? (FieldSortBuilder)new FieldSortBuilder(this.sortField).missing((Object)"_last").order(this.sortDescending ? SortOrder.DESC : SortOrder.ASC) : SortBuilders.fieldSort((String)"_doc");
        BoolQueryBuilder recordFilter = new BoolQueryBuilder().filter(query).filter((QueryBuilder)new TermsQueryBuilder(Result.RESULT_TYPE.getPreferredName(), new String[]{"record"}));
        if (this.timestamp != null) {
            recordFilter.filter((QueryBuilder)QueryBuilders.termQuery((String)Result.TIMESTAMP.getPreferredName(), (long)this.timestamp.getTime()));
        }
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder().from(this.from).size(this.size).query((QueryBuilder)recordFilter).sort((SortBuilder)sb).fetchSource(true);
        for (String sortField : SECONDARY_SORT) {
            searchSourceBuilder.sort(sortField, this.sortDescending ? SortOrder.DESC : SortOrder.ASC);
        }
        return searchSourceBuilder;
    }
}

