/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.sniff;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.elasticsearch.client.Node;
import org.elasticsearch.client.Request;
import org.elasticsearch.client.Response;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.sniff.NodesSniffer;

public final class ElasticsearchNodesSniffer
implements NodesSniffer {
    private static final Log logger = LogFactory.getLog(ElasticsearchNodesSniffer.class);
    public static final long DEFAULT_SNIFF_REQUEST_TIMEOUT = TimeUnit.SECONDS.toMillis(1L);
    private final RestClient restClient;
    private final Request request;
    private final Scheme scheme;
    private final JsonFactory jsonFactory = new JsonFactory();

    public ElasticsearchNodesSniffer(RestClient restClient) {
        this(restClient, DEFAULT_SNIFF_REQUEST_TIMEOUT, Scheme.HTTP);
    }

    public ElasticsearchNodesSniffer(RestClient restClient, long sniffRequestTimeoutMillis, Scheme scheme) {
        this.restClient = Objects.requireNonNull(restClient, "restClient cannot be null");
        if (sniffRequestTimeoutMillis < 0L) {
            throw new IllegalArgumentException("sniffRequestTimeoutMillis must be greater than 0");
        }
        this.request = new Request("GET", "/_nodes/http");
        this.request.addParameter("timeout", sniffRequestTimeoutMillis + "ms");
        this.scheme = Objects.requireNonNull(scheme, "scheme cannot be null");
    }

    @Override
    public List<Node> sniff() throws IOException {
        Response response = this.restClient.performRequest(this.request);
        return ElasticsearchNodesSniffer.readHosts(response.getEntity(), this.scheme, this.jsonFactory);
    }

    static List<Node> readHosts(HttpEntity entity, Scheme scheme, JsonFactory jsonFactory) throws IOException {
        try (InputStream inputStream = entity.getContent();){
            JsonParser parser = jsonFactory.createParser(inputStream);
            if (parser.nextToken() != JsonToken.START_OBJECT) {
                throw new IOException("expected data to start with an object");
            }
            ArrayList<Node> nodes = new ArrayList<Node>();
            while (parser.nextToken() != JsonToken.END_OBJECT) {
                if (parser.getCurrentToken() != JsonToken.START_OBJECT) continue;
                if ("nodes".equals(parser.getCurrentName())) {
                    while (parser.nextToken() != JsonToken.END_OBJECT) {
                        JsonToken token = parser.nextToken();
                        assert (token == JsonToken.START_OBJECT);
                        String nodeId = parser.getCurrentName();
                        Node node = ElasticsearchNodesSniffer.readNode(nodeId, parser, scheme);
                        if (node == null) continue;
                        nodes.add(node);
                    }
                    continue;
                }
                parser.skipChildren();
            }
            ArrayList<Node> arrayList = nodes;
            return arrayList;
        }
    }

    private static Node readNode(String nodeId, JsonParser parser, Scheme scheme) throws IOException {
        HttpHost publishedHost = null;
        HashSet<HttpHost> boundHosts = new HashSet<HttpHost>();
        String name = null;
        String version = null;
        HashMap<String, String> protoAttributes = new HashMap<String, String>();
        boolean sawRoles = false;
        boolean master = false;
        boolean data = false;
        boolean ingest = false;
        String fieldName = null;
        while (parser.nextToken() != JsonToken.END_OBJECT) {
            if (parser.getCurrentToken() == JsonToken.FIELD_NAME) {
                fieldName = parser.getCurrentName();
                continue;
            }
            if (parser.getCurrentToken() == JsonToken.START_OBJECT) {
                if ("http".equals(fieldName)) {
                    while (parser.nextToken() != JsonToken.END_OBJECT) {
                        if (parser.getCurrentToken() == JsonToken.VALUE_STRING && "publish_address".equals(parser.getCurrentName())) {
                            String host;
                            Object publishAddressAsURI;
                            String address = parser.getValueAsString();
                            if (address.contains("/")) {
                                String[] stringArray = address.split("/", 2);
                                publishAddressAsURI = URI.create((Object)((Object)scheme) + "://" + stringArray[1]);
                                host = stringArray[0];
                            } else {
                                publishAddressAsURI = URI.create((Object)((Object)scheme) + "://" + address);
                                host = ((URI)publishAddressAsURI).getHost();
                            }
                            publishedHost = new HttpHost(host, ((URI)publishAddressAsURI).getPort(), ((URI)publishAddressAsURI).getScheme());
                            continue;
                        }
                        if (parser.currentToken() == JsonToken.START_ARRAY && "bound_address".equals(parser.getCurrentName())) {
                            while (parser.nextToken() != JsonToken.END_ARRAY) {
                                URI boundAddressAsURI = URI.create((Object)((Object)scheme) + "://" + parser.getValueAsString());
                                boundHosts.add(new HttpHost(boundAddressAsURI.getHost(), boundAddressAsURI.getPort(), boundAddressAsURI.getScheme()));
                            }
                            continue;
                        }
                        if (parser.getCurrentToken() != JsonToken.START_OBJECT) continue;
                        parser.skipChildren();
                    }
                    continue;
                }
                if ("attributes".equals(fieldName)) {
                    while (parser.nextToken() != JsonToken.END_OBJECT) {
                        if (parser.getCurrentToken() == JsonToken.VALUE_STRING) {
                            String oldValue = protoAttributes.put(parser.getCurrentName(), parser.getValueAsString());
                            if (oldValue == null) continue;
                            throw new IOException("repeated attribute key [" + parser.getCurrentName() + "]");
                        }
                        parser.skipChildren();
                    }
                    continue;
                }
                parser.skipChildren();
                continue;
            }
            if (parser.currentToken() == JsonToken.START_ARRAY) {
                if ("roles".equals(fieldName)) {
                    sawRoles = true;
                    block14: while (parser.nextToken() != JsonToken.END_ARRAY) {
                        switch (parser.getText()) {
                            case "master": {
                                master = true;
                                continue block14;
                            }
                            case "data": {
                                data = true;
                                continue block14;
                            }
                            case "ingest": {
                                ingest = true;
                                continue block14;
                            }
                        }
                        logger.warn((Object)("unknown role [" + parser.getText() + "] on node [" + nodeId + "]"));
                    }
                    continue;
                }
                parser.skipChildren();
                continue;
            }
            if (!parser.currentToken().isScalarValue()) continue;
            if ("version".equals(fieldName)) {
                version = parser.getText();
                continue;
            }
            if (!"name".equals(fieldName)) continue;
            name = parser.getText();
        }
        if (publishedHost == null) {
            logger.debug((Object)("skipping node [" + nodeId + "] with http disabled"));
            return null;
        }
        HashMap<String, List<String>> realAttributes = new HashMap<String, List<String>>(protoAttributes.size());
        ArrayList keys = new ArrayList(protoAttributes.keySet());
        for (String string : keys) {
            String value;
            if (!string.endsWith(".0")) continue;
            String realKey = string.substring(0, string.length() - 2);
            ArrayList<String> values = new ArrayList<String>();
            int i = 0;
            while ((value = (String)protoAttributes.remove(realKey + "." + i)) != null) {
                values.add(value);
                ++i;
            }
            realAttributes.put(realKey, Collections.unmodifiableList(values));
        }
        for (Map.Entry entry : protoAttributes.entrySet()) {
            realAttributes.put((String)entry.getKey(), Collections.singletonList(entry.getValue()));
        }
        if (version.startsWith("2.")) {
            boolean clientAttribute = ElasticsearchNodesSniffer.v2RoleAttributeValue(realAttributes, "client", false);
            Boolean bl = ElasticsearchNodesSniffer.v2RoleAttributeValue(realAttributes, "master", null);
            Boolean dataAttribute = ElasticsearchNodesSniffer.v2RoleAttributeValue(realAttributes, "data", null);
            boolean bl2 = bl == null ? !clientAttribute : (master = bl.booleanValue());
            data = dataAttribute == null ? !clientAttribute : dataAttribute;
        } else assert (sawRoles) : "didn't see roles for [" + nodeId + "]";
        assert (boundHosts.contains(publishedHost)) : "[" + nodeId + "] doesn't make sense! publishedHost should be in boundHosts";
        logger.trace((Object)("adding node [" + nodeId + "]"));
        return new Node(publishedHost, boundHosts, name, version, new Node.Roles(master, data, ingest), Collections.unmodifiableMap(realAttributes));
    }

    private static Boolean v2RoleAttributeValue(Map<String, List<String>> attributes, String name, Boolean defaultValue) throws IOException {
        List<String> valueList = attributes.remove(name);
        if (valueList == null) {
            return defaultValue;
        }
        if (valueList.size() != 1) {
            throw new IOException("expected only a single attribute value for [" + name + "] but got " + valueList);
        }
        switch (valueList.get(0)) {
            case "true": {
                return true;
            }
            case "false": {
                return false;
            }
        }
        throw new IOException("expected [" + name + "] to be either [true] or [false] but was [" + valueList.get(0) + "]");
    }

    public static enum Scheme {
        HTTP("http"),
        HTTPS("https");

        private final String name;

        private Scheme(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

