#ifndef FILTER_H
#define FILTER_H  1


/* ========================================================================== */
/* Include files */

#include "core.h"


/*! \addtogroup FILTER */
/*! @{ */


/* ========================================================================== */
/* Data types */

/* Locale 'LC_CTYPE' codeset */
enum filter_cs
{
   FILTER_CS_ASCII,
   FILTER_CS_ISO8859_1,
   FILTER_CS_UTF_8
};


/*! @} */


/* ========================================================================== */
/* Function prototypes */

int  filter_init(int);
void  filter_exit(void);
int  filter_match_own(const struct core_hierarchy_element*);
int  filter_match_reply_to_own(const struct core_hierarchy_element*);
int  filter_get_score(const struct core_hierarchy_element*);
int  filter_check_testgroup(const char*);
enum filter_cs  filter_get_locale_ctype(void);


#endif  /* FILTER_H */

/* EOF */
