/*
 * SPDX-FileType: SOURCE
 * SPDX-FileCopyrightText: Michael Bäuerle
 * SPDX-License-Identifier: BSD-2-Clause
 */

#ifndef JPIC0_I_ERRNO_H
#define JPIC0_I_ERRNO_H  1

#include <errno.h>


/*
 * Header file for error codes
 *
 * This file is used by the library and will not be installed.
 */


#pragma GCC visibility push(internal)


/*! \cond DO_NOT_DOCUMENT */


/*
 * Error codes
 *
 * On POSIX systems errno is set to the values defined by the Solaris 11 API.
 * For plain C90 the value -1 is used for all errors.
 */
#if defined(E2BIG) && defined(EBADF) && defined(EILSEQ) && defined(EINVAL)
#define JPIC0_I_E2BIG   E2BIG
#define JPIC0_I_EBADF   EBADF
#define JPIC0_I_EILSEQ  EILSEQ
#define JPIC0_I_EINVAL  EINVAL
#else  /* defined(E2BIG) && defined(EBADF) && defined(EILSEQ) && ... */
#define JPIC0_I_E2BIG   -1
#define JPIC0_I_EBADF   -1
#define JPIC0_I_EILSEQ  -1
#define JPIC0_I_EINVAL  -1
#endif  /* defined(E2BIG) && defined(EBADF) && defined(EILSEQ) && ... */


/*! \endcond */


#pragma GCC visibility pop


#endif  /* JPIC0_I_ERRNO_H */
