/*
 * SPDX-FileType: SOURCE
 * SPDX-FileCopyrightText: Michael Bäuerle
 * SPDX-License-Identifier: BSD-2-Clause
 */

#ifndef JPIC0_I_ICONV_RFC1468_H
#define JPIC0_I_ICONV_RFC1468_H  1


/*
 * Header file for RFC 1468 decoder
 *
 * This file is used by the library and will not be installed.
 */

#include "libjpiconv-0/iconv_bool.h"


#pragma GCC visibility push(internal)


/*! \cond DO_NOT_DOCUMENT */


/*
 * Unicode replacement codepoint for ISO 646-JP codepoint 0x5C
 *
 * Must be an UTF-8 octet-sequence for a single codepoint (max. 4 octets)
 * as NUL-terminated string.
 */
#define JPIC0_I_ISO646JP_YEN_SIGN  "\xC2\xA5"  /* U+00A5  YEN SIGN */


/*
 * Unicode replacement codepoint for ISO 646-JP codepont 0x7E
 *
 * Must be an UTF-8 octet-sequence for a single codepoint (max. 4 octets)
 * as NUL-terminated string.
 */
#define JPIC0_I_ISO646JP_OVERLINE  "\xE2\x80\xBE"  /* U+203E  OVERLINE */


/* Convert JUNET (RFC 1468) encoding to Unicode (UTF-8) */
jpic0_i_bool jpic0_i_rfc1468(char *inarray, size_t *inlen,
                             char *outarray, size_t *outlen,
                             int flag, size_t *nonident);


/*! \endcond */


#pragma GCC visibility pop


#endif  /* JPIC0_I_ICONV_RFC1468_H */
