/*
 * SPDX-FileType: SOURCE
 * SPDX-FileCopyrightText: Michael Bäuerle
 * SPDX-License-Identifier: BSD-2-Clause
 */

#ifndef SSIC0_I_ERRNO_H
#define SSIC0_I_ERRNO_H  1

#include <errno.h>


/*
 * Header file for error codes
 *
 * This file is used by the library and will not be installed.
 */


#pragma GCC visibility push(internal)


/*! \cond DO_NOT_DOCUMENT */


/*
 * Error codes
 *
 * On POSIX systems errno is set to the values defined by the Solaris 11 API.
 * For plain C90 the value -1 is used for all errors.
 */
#if defined(EBADF) && defined(EILSEQ) && defined(E2BIG)
#define SSIC0_I_EBADF   EBADF
#define SSIC0_I_EILSEQ  EILSEQ
#define SSIC0_I_E2BIG   E2BIG
#else  /* defined(EBADF) && defined(EILSEQ) && defined(E2BIG) */
#define SSIC0_I_EBADF   -1
#define SSIC0_I_EILSEQ  -1
#define SSIC0_I_E2BIG   -1
#endif  /* defined(EBADF) && defined(EILSEQ) && defined(E2BIG) */


/*! \endcond */


#pragma GCC visibility pop


#endif  /* SSIC0_I_ERRNO_H */
