/*
 * Supported encoding list functions for libssiconv
 *
 * SPDX-FileType: SOURCE
 * SPDX-FileCopyrightText: Michael Bäuerle
 * SPDX-License-Identifier: BSD-2-Clause
 */

#include <stdio.h>

#include "libssiconv-0/iconv.h"  /* Always include main header file first */
#include "libssiconv-0/iconv_name.h"


/* ========================================================================== */
#if SSIC0_I_NAME_ENABLE_ALIASES
static void ssic0_i_print_alias(const char **table)
{
    size_t i = 0;

    while (NULL != ssic0_i_name_src_alias[i].name)
    {
        if (ssic0_i_name_src_alias[i].table == table)
        {
            printf(" %s", ssic0_i_name_src_alias[i].name);
        }
        ++i;
    }
}
#endif  /* SSIC0_I_NAME_ENABLE_ALIASES */


/* ========================================================================== */
#if SSIC0_I_NAME_ENABLE_NONSTANDARD
static void ssic0_i_print_nonstd(const char **table)
{
    size_t i = 0;

    while (NULL != ssic0_i_name_src_nonstd[i].name)
    {
        if (ssic0_i_name_src_nonstd[i].table == table)
        {
            printf(" %s", ssic0_i_name_src_nonstd[i].name);
        }
        ++i;
    }
}
#endif  /* SSIC0_I_NAME_ENABLE_NONSTANDARD */


/* ========================================================================== */
void ssic0_print_codesets(void)
{

    printf("Supported output encodings\n");
    printf("--------------------------\n");
    {
        size_t i = 0;

        while (NULL != ssic0_i_name_tgt[i].name)
        {
            printf("%s\n", ssic0_i_name_tgt[i].name);
            ++i;
        }
    }

    printf("\nSupported input encodings\n");
    printf("-------------------------\n");
    {
        size_t i = 0;

        while (NULL != ssic0_i_name_src[i].name)
        {
            printf("%s", ssic0_i_name_src[i].name);
#if SSIC0_I_NAME_ENABLE_ALIASES
            ssic0_i_print_alias(ssic0_i_name_src[i].table);
#endif  /* SSIC0_I_NAME_ENABLE_ALIASES */
#if SSIC0_I_NAME_ENABLE_NONSTANDARD
            ssic0_i_print_nonstd(ssic0_i_name_src[i].table);
#endif  /* SSIC0_I_NAME_ENABLE_NONSTANDARD */
            printf("\n");
            ++i;
        }
    }
}
