<!--
SPDX-FileCopyrightText: 2023 Raintank, Inc. dba Grafana Labs

SPDX-License-Identifier: AGPL-3.0-only
-->

xk6-dashboard `v0.5.5` is here 🎉! This release includes:

- Record and replay events
- Easier reporting later
- Replay format changed, which is a breaking changs.
- Internal refactors

## Breaking changes

### Replay format changed

The `dashboard replay` command now plays back event files, which is a breaking change. Previously, the command played back a file saved in the k6 json output format. This had some disadvantages:
 - relatively slow playback for large files
 - only approximately the same values appeared on the dashboard and in the report as during the test run
 - the json output does not contain all the data to fully reconstruct the events

However, the advantage of using the k6 json output is that it can be saved without the dashboard extension and later replay on a k6 that includes the dashboard extension.

In order to maintain this advantage, a `dashboard aggregate`` command was created. Using this, the k6 json output file can be converted into a dashboard event file.

## New features

### Record and replay events

With the help of the new *record* parameter, the dashboard events generated during the test run can be saved. The `dashboard replay`` command now plays back event files.

The file size of the event is a fraction of the previously used k6 json output format (`--out json`). Playback speed has also improved significantly. In addition, during playback, the exact same result can be seen on the dashboard and in the report as during the test run.

### Easier reporting later

A report can also be created afterwards with the help of the `dashboard replay` command, but a `dashboard report` command has been created for the simpler subsequent report creation. To use the command, you only need to enter the names of the event file and the report file as parameters.

## Maintenance and internal improvements

This release contains a refactor that affects many files but is not risky. Primarily, the folder structure has changed and only the necessary API is visible to the outside world. In addition, some internal renamings were made for more consistent naming.

