// Code generated by tools/cmd/genjwa/main.go. DO NOT EDIT

package jwa_test

import (
	"encoding/json"
	"strconv"
	"testing"

	"github.com/lestrrat-go/jwx/v3/jwa"
	"github.com/stretchr/testify/require"
)

func TestCompressionAlgorithm(t *testing.T) {
	t.Parallel()
	t.Run(`Lookup the object`, func(t *testing.T) {
		t.Parallel()
		v, ok := jwa.LookupCompressionAlgorithm("DEF")
		require.True(t, ok, `Lookup should succeed`)
		require.Equal(t, jwa.Deflate(), v, `Lookup value should be equal to constant`)
	})
	t.Run(`Unmarshal the string DEF`, func(t *testing.T) {
		t.Parallel()
		var dst jwa.CompressionAlgorithm
		require.NoError(t, json.Unmarshal([]byte(strconv.Quote("DEF")), &dst), `UnmarshalJSON is successful`)
		require.Equal(t, jwa.Deflate(), dst, `unmarshaled value should be equal to constant`)
	})
	t.Run(`stringification for DEF`, func(t *testing.T) {
		t.Parallel()
		require.Equal(t, "DEF", jwa.Deflate().String(), `stringified value matches`)
	})
	t.Run(`Lookup the object`, func(t *testing.T) {
		t.Parallel()
		v, ok := jwa.LookupCompressionAlgorithm("")
		require.True(t, ok, `Lookup should succeed`)
		require.Equal(t, jwa.NoCompress(), v, `Lookup value should be equal to constant`)
	})
	t.Run(`Unmarshal the string `, func(t *testing.T) {
		t.Parallel()
		var dst jwa.CompressionAlgorithm
		require.NoError(t, json.Unmarshal([]byte(strconv.Quote("")), &dst), `UnmarshalJSON is successful`)
		require.Equal(t, jwa.NoCompress(), dst, `unmarshaled value should be equal to constant`)
	})
	t.Run(`stringification for `, func(t *testing.T) {
		t.Parallel()
		require.Equal(t, "", jwa.NoCompress().String(), `stringified value matches`)
	})
	t.Run(`Unmarshal should fail for invalid value (totally made up) string value`, func(t *testing.T) {
		t.Parallel()
		var dst jwa.CompressionAlgorithm
		require.Error(t, json.Unmarshal([]byte(`totallyInvalidValue`), &dst), `Unmarshal should fail`)
	})
	t.Run(`check list of elements`, func(t *testing.T) {
		t.Parallel()
		var expected = map[jwa.CompressionAlgorithm]struct{}{
			jwa.Deflate():    {},
			jwa.NoCompress(): {},
		}
		for _, v := range jwa.CompressionAlgorithms() {
			_, ok := expected[v]
			require.True(t, ok, `%q should be in the list for CompressionAlgorithm`, v)
			delete(expected, v)
		}
		require.Len(t, expected, 0)
	})
}

// Note: this test can NOT be run in parallel as it uses options with global effect.
func TestCompressionAlgorithmCustomAlgorithm(t *testing.T) {
	// These subtests can NOT be run in parallel as options with global effect change.
	const customAlgorithmValue = `custom-algorithm`
	customAlgorithm := jwa.NewCompressionAlgorithm(customAlgorithmValue)
	// Unregister the custom algorithm, in case tests fail.
	t.Cleanup(func() {
		jwa.UnregisterCompressionAlgorithm(customAlgorithm)
	})
	t.Run(`with custom algorithm registered`, func(t *testing.T) {
		jwa.RegisterCompressionAlgorithm(customAlgorithm)
		t.Run(`Lookup the object`, func(t *testing.T) {
			t.Parallel()
			v, ok := jwa.LookupCompressionAlgorithm(customAlgorithmValue)
			require.True(t, ok, `Lookup should succeed`)
			require.Equal(t, customAlgorithm, v, `Lookup value should be equal to constant`)
		})
		t.Run(`Unmarshal custom algorithm`, func(t *testing.T) {
			t.Parallel()
			var dst jwa.CompressionAlgorithm
			require.NoError(t, json.Unmarshal([]byte(strconv.Quote(customAlgorithmValue)), &dst), `Unmarshal is successful`)
			require.Equal(t, customAlgorithm, dst, `accepted value should be equal to variable`)
		})
	})
	t.Run(`with custom algorithm deregistered`, func(t *testing.T) {
		jwa.UnregisterCompressionAlgorithm(customAlgorithm)
		t.Run(`Lookup the object`, func(t *testing.T) {
			t.Parallel()
			_, ok := jwa.LookupCompressionAlgorithm(customAlgorithmValue)
			require.False(t, ok, `Lookup should fail`)
		})
		t.Run(`Unmarshal custom algorithm`, func(t *testing.T) {
			t.Parallel()
			var dst jwa.CompressionAlgorithm
			require.Error(t, json.Unmarshal([]byte(customAlgorithmValue), &dst), `Unmarshal should fail`)
		})
	})
}
