/**
 * Modify the JSX to use the IconBase component as a wrapper
 */
const modifyJSX = (jsx) => {
  jsx.openingElement.name.name = 'IconBase';
  jsx.openingElement.attributes = [
    {
      type: 'JSXSpreadAttribute',
      argument: {
        type: 'Identifier',
        name: 'props',
      },
    },
  ];

  jsx.closingElement.name.name = 'IconBase';

  return jsx;
};

const comments = `
// This is an auto-generated file, created by svgr-cli.
// Do not edit this file manually.
// To update the component, modify the template in templates/icon.js.
// Run "yarn generate" to update.
`;
const imports = `
import React, { memo } from 'react';

import { IconBase, IconProps } from '../IconBase';
`;
const template = ({ exports, jsx, componentName }, { tpl }) => {
  return tpl`
${comments}
${imports}

const ${componentName} = (props: IconProps) => (
  ${modifyJSX(jsx)}
);

${exports};
`;
};

module.exports = template;
