/*
 * Copyright (c) 2000, 2020, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 */

package javax.sql;

/**
 * <P>
 * An object that registers to be notified of events generated by a
 * {@code PooledConnection} object.
 * <P>
 * The {@code ConnectionEventListener} interface is implemented by a
 * connection pooling component.  A connection pooling component will
 * usually be provided by a JDBC driver vendor or another system software
 * vendor.  A JDBC driver notifies a {@code ConnectionEventListener}
 * object when an application is finished using a pooled connection with
 * which the listener has registered.  The notification
 * occurs after the application calls the method {@code close} on
 * its representation of a {@code PooledConnection} object.  A
 * {@code ConnectionEventListener} is also notified when a
 * connection error occurs due to the fact that the {@code PooledConnection}
 * is unfit for future use---the server has crashed, for example.
 * The listener is notified by the JDBC driver just before the driver throws an
 * {@code SQLException} to the application using the
 * {@code PooledConnection} object.
 *
 * @since 1.4
 */

public interface ConnectionEventListener extends java.util.EventListener {

  /**
   * Notifies this {@code ConnectionEventListener} that
   * the application has called the method {@code close} on its
   * representation of a pooled connection.
   *
   * @param event an event object describing the source of
   * the event
   */
  void connectionClosed(ConnectionEvent event);

  /**
   * Notifies this {@code ConnectionEventListener} that
   * a fatal error has occurred and the pooled connection can
   * no longer be used.  The driver makes this notification just
   * before it throws the application the {@code SQLException}
   * contained in the given {@code ConnectionEvent} object.
   *
   * @param event an event object describing the source of
   * the event and containing the {@code SQLException} that the
   * driver is about to throw
   */
  void connectionErrorOccurred(ConnectionEvent event);

 }
