/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.relaxng.pattern;

import com.thaiopensource.relaxng.pattern.AbstractPatternFunction;
import com.thaiopensource.relaxng.pattern.AttributePattern;
import com.thaiopensource.relaxng.pattern.ChoicePattern;
import com.thaiopensource.relaxng.pattern.DataExceptPattern;
import com.thaiopensource.relaxng.pattern.DataPattern;
import com.thaiopensource.relaxng.pattern.ElementPattern;
import com.thaiopensource.relaxng.pattern.GroupPattern;
import com.thaiopensource.relaxng.pattern.IdTypeMap;
import com.thaiopensource.relaxng.pattern.InterleavePattern;
import com.thaiopensource.relaxng.pattern.ListPattern;
import com.thaiopensource.relaxng.pattern.NameClass;
import com.thaiopensource.relaxng.pattern.NameClassVisitor;
import com.thaiopensource.relaxng.pattern.NameFormatter;
import com.thaiopensource.relaxng.pattern.OneOrMorePattern;
import com.thaiopensource.relaxng.pattern.Pattern;
import com.thaiopensource.relaxng.pattern.PatternFunction;
import com.thaiopensource.relaxng.pattern.SchemaBuilderImpl;
import com.thaiopensource.relaxng.pattern.SimpleNameClass;
import com.thaiopensource.relaxng.pattern.ValuePattern;
import com.thaiopensource.util.VoidValue;
import com.thaiopensource.xml.util.Name;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.relaxng.datatype.Datatype;
import org.xml.sax.ErrorHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class IdTypeMapBuilder {
    private boolean hadError;
    private final ErrorHandler eh;
    private final PatternFunction<Integer> idTypeFunction = new IdTypeFunction();
    private final IdTypeMapImpl idTypeMap = new IdTypeMapImpl();
    private final Set<ElementPattern> elementProcessed = new HashSet<ElementPattern>();
    private final Stack<ElementPattern> elementsToProcess = new Stack();
    private final List<PossibleConflict> possibleConflicts = new ArrayList<PossibleConflict>();

    private void notePossibleConflict(NameClass nameClass, NameClass nameClass2, Locator locator) {
        this.possibleConflicts.add(new PossibleConflict(nameClass, nameClass2, locator));
    }

    private void error(String string, Locator locator) {
        this.hadError = true;
        if (this.eh != null) {
            try {
                this.eh.error(new SAXParseException(SchemaBuilderImpl.localizer.message(string), locator));
            }
            catch (SAXException sAXException) {
                throw new WrappedSAXException(sAXException);
            }
        }
    }

    private void error(String string, Name name, Name name2, Locator locator) {
        this.hadError = true;
        if (this.eh != null) {
            try {
                this.eh.error(new SAXParseException(SchemaBuilderImpl.localizer.message(string, NameFormatter.format(name), NameFormatter.format(name2)), locator));
            }
            catch (SAXException sAXException) {
                throw new WrappedSAXException(sAXException);
            }
        }
    }

    public IdTypeMapBuilder(ErrorHandler errorHandler, Pattern pattern) throws SAXException {
        this.eh = errorHandler;
        try {
            pattern.apply(new BuildFunction(null, null));
            while (this.elementsToProcess.size() > 0) {
                ElementPattern elementPattern = this.elementsToProcess.pop();
                elementPattern.getContent().apply(new BuildFunction(elementPattern.getNameClass(), elementPattern.getLocator()));
            }
            block3: for (PossibleConflict possibleConflict : this.possibleConflicts) {
                if (possibleConflict.elementNameClass instanceof SimpleNameClass && possibleConflict.attributeNameClass instanceof SimpleNameClass) {
                    Object object;
                    Name name = ((SimpleNameClass)possibleConflict.elementNameClass).getName();
                    int n = this.idTypeMap.getIdType(name, (Name)(object = ((SimpleNameClass)possibleConflict.attributeNameClass).getName()));
                    if (n == 0) continue;
                    this.error("id_type_conflict", name, (Name)object, possibleConflict.locator);
                    continue;
                }
                for (Object object : this.idTypeMap.table.keySet()) {
                    if (!possibleConflict.elementNameClass.contains(((ScopedName)object).elementName) || !possibleConflict.attributeNameClass.contains(((ScopedName)object).attributeName)) continue;
                    this.error("id_type_conflict", ((ScopedName)object).elementName, ((ScopedName)object).attributeName, possibleConflict.locator);
                    continue block3;
                }
            }
        }
        catch (WrappedSAXException wrappedSAXException) {
            throw wrappedSAXException.cause;
        }
    }

    public IdTypeMap getIdTypeMap() {
        if (this.hadError) {
            return null;
        }
        return this.idTypeMap;
    }

    private static class IdTypeMapImpl
    implements IdTypeMap {
        private final Map<ScopedName, Integer> table = new HashMap<ScopedName, Integer>();

        private IdTypeMapImpl() {
        }

        @Override
        public int getIdType(Name name, Name name2) {
            Integer n = this.table.get(new ScopedName(name, name2));
            if (n == null) {
                return 0;
            }
            return n;
        }

        private void add(Name name, Name name2, int n) {
            this.table.put(new ScopedName(name, name2), n);
        }
    }

    private static class PossibleConflict {
        private final NameClass elementNameClass;
        private final NameClass attributeNameClass;
        private final Locator locator;

        private PossibleConflict(NameClass nameClass, NameClass nameClass2, Locator locator) {
            this.elementNameClass = nameClass;
            this.attributeNameClass = nameClass2;
            this.locator = locator;
        }
    }

    private static class WrappedSAXException
    extends RuntimeException {
        private final SAXException cause;

        WrappedSAXException(SAXException sAXException) {
            this.cause = sAXException;
        }
    }

    private class IdTypeFunction
    extends AbstractPatternFunction<Integer> {
        private IdTypeFunction() {
        }

        @Override
        public Integer caseOther(Pattern pattern) {
            return 0;
        }

        @Override
        public Integer caseData(DataPattern dataPattern) {
            return dataPattern.getDatatype().getIdType();
        }

        @Override
        public Integer caseDataExcept(DataExceptPattern dataExceptPattern) {
            return dataExceptPattern.getDatatype().getIdType();
        }

        @Override
        public Integer caseValue(ValuePattern valuePattern) {
            return valuePattern.getDatatype().getIdType();
        }
    }

    private class BuildFunction
    extends AbstractPatternFunction<VoidValue> {
        private final NameClass elementNameClass;
        private final Locator locator;
        private final boolean attributeIsParent;

        BuildFunction(NameClass nameClass, Locator locator) {
            this.elementNameClass = nameClass;
            this.locator = locator;
            this.attributeIsParent = false;
        }

        BuildFunction(NameClass nameClass, Locator locator, boolean bl) {
            this.elementNameClass = nameClass;
            this.locator = locator;
            this.attributeIsParent = bl;
        }

        private BuildFunction down() {
            if (!this.attributeIsParent) {
                return this;
            }
            return new BuildFunction(this.elementNameClass, this.locator, false);
        }

        @Override
        public VoidValue caseChoice(ChoicePattern choicePattern) {
            BuildFunction buildFunction = this.down();
            choicePattern.getOperand1().apply(buildFunction);
            choicePattern.getOperand2().apply(buildFunction);
            return VoidValue.VOID;
        }

        @Override
        public VoidValue caseInterleave(InterleavePattern interleavePattern) {
            BuildFunction buildFunction = this.down();
            interleavePattern.getOperand1().apply(buildFunction);
            interleavePattern.getOperand2().apply(buildFunction);
            return VoidValue.VOID;
        }

        @Override
        public VoidValue caseGroup(GroupPattern groupPattern) {
            BuildFunction buildFunction = this.down();
            groupPattern.getOperand1().apply(buildFunction);
            groupPattern.getOperand2().apply(buildFunction);
            return VoidValue.VOID;
        }

        @Override
        public VoidValue caseOneOrMore(OneOrMorePattern oneOrMorePattern) {
            oneOrMorePattern.getOperand().apply(this.down());
            return VoidValue.VOID;
        }

        @Override
        public VoidValue caseElement(ElementPattern elementPattern) {
            if (IdTypeMapBuilder.this.elementProcessed.contains(elementPattern)) {
                return VoidValue.VOID;
            }
            IdTypeMapBuilder.this.elementProcessed.add(elementPattern);
            IdTypeMapBuilder.this.elementsToProcess.push(elementPattern);
            return VoidValue.VOID;
        }

        @Override
        public VoidValue caseAttribute(AttributePattern attributePattern) {
            int n = (Integer)attributePattern.getContent().apply(IdTypeMapBuilder.this.idTypeFunction);
            if (n != 0) {
                NameClass nameClass = attributePattern.getNameClass();
                if (!(nameClass instanceof SimpleNameClass)) {
                    IdTypeMapBuilder.this.error("id_attribute_name_class", attributePattern.getLocator());
                    return VoidValue.VOID;
                }
                this.elementNameClass.accept(new ElementNameClassVisitor(((SimpleNameClass)nameClass).getName(), this.locator, n));
            } else {
                IdTypeMapBuilder.this.notePossibleConflict(this.elementNameClass, attributePattern.getNameClass(), this.locator);
            }
            attributePattern.getContent().apply(new BuildFunction(null, attributePattern.getLocator(), true));
            return VoidValue.VOID;
        }

        private void datatype(Datatype datatype) {
            if (datatype.getIdType() != 0 && !this.attributeIsParent) {
                IdTypeMapBuilder.this.error("id_parent", this.locator);
            }
        }

        @Override
        public VoidValue caseData(DataPattern dataPattern) {
            this.datatype(dataPattern.getDatatype());
            return VoidValue.VOID;
        }

        @Override
        public VoidValue caseDataExcept(DataExceptPattern dataExceptPattern) {
            this.datatype(dataExceptPattern.getDatatype());
            dataExceptPattern.getExcept().apply(this.down());
            return VoidValue.VOID;
        }

        @Override
        public VoidValue caseValue(ValuePattern valuePattern) {
            this.datatype(valuePattern.getDatatype());
            return VoidValue.VOID;
        }

        @Override
        public VoidValue caseList(ListPattern listPattern) {
            listPattern.getOperand().apply(this.down());
            return VoidValue.VOID;
        }

        @Override
        public VoidValue caseOther(Pattern pattern) {
            return VoidValue.VOID;
        }
    }

    private static class ScopedName {
        private final Name elementName;
        private final Name attributeName;

        private ScopedName(Name name, Name name2) {
            this.elementName = name;
            this.attributeName = name2;
        }

        public int hashCode() {
            return this.elementName.hashCode() ^ this.attributeName.hashCode();
        }

        public boolean equals(Object object) {
            if (!(object instanceof ScopedName)) {
                return false;
            }
            ScopedName scopedName = (ScopedName)object;
            return this.elementName.equals(scopedName.elementName) && this.attributeName.equals(scopedName.attributeName);
        }
    }

    private class ElementNameClassVisitor
    implements NameClassVisitor {
        private final Name attributeName;
        private final Locator locator;
        private final int idType;

        ElementNameClassVisitor(Name name, Locator locator, int n) {
            this.attributeName = name;
            this.locator = locator;
            this.idType = n;
        }

        @Override
        public void visitChoice(NameClass nameClass, NameClass nameClass2) {
            nameClass.accept(this);
            nameClass2.accept(this);
        }

        @Override
        public void visitName(Name name) {
            int n = IdTypeMapBuilder.this.idTypeMap.getIdType(name, this.attributeName);
            if (n != 0 && n != this.idType) {
                IdTypeMapBuilder.this.error("id_type_conflict", name, this.attributeName, this.locator);
            }
            IdTypeMapBuilder.this.idTypeMap.add(name, this.attributeName, this.idType);
        }

        @Override
        public void visitNsName(String string) {
            this.visitOther();
        }

        @Override
        public void visitNsNameExcept(String string, NameClass nameClass) {
            this.visitOther();
        }

        @Override
        public void visitAnyName() {
            this.visitOther();
        }

        @Override
        public void visitAnyNameExcept(NameClass nameClass) {
            this.visitOther();
        }

        @Override
        public void visitNull() {
        }

        @Override
        public void visitError() {
        }

        private void visitOther() {
            IdTypeMapBuilder.this.error("id_element_name_class", this.locator);
        }
    }
}

