/*
  Copyright (C) 2004-2005 Tommi Tervonen, Petteri Klemola, Pasi Orovuo, Marko Mattila

  This file is part of Kajaani Kombat.

  Kajaani Kombat is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  Kajaani Kombat is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with Kajaani Kombat; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef CONFIG_H_INCLUDED
#define CONFIG_H_INCLUDED

#include <string>
#include <stdio.h>
#include "globals.h"
#include "SDL.h"

using namespace std;

class config
{
  public:
    /* For some reason these get messed up with
     * curses KEY_* defines in my setup
     * so added _ in front
     */
    enum key_id {
      _KEY_UP = 0,
      _KEY_DOWN,
      _KEY_LEFT,
      _KEY_RIGHT,
      _KEY_ACTION1,
      _KEY_ACTION2,
      _KEY_TALK,
      _NUM_KEYS
    };
    enum player_id {
      PLAYER_1 = 0,
      PLAYER_2,
      MAX_LOCAL_PLAYERS
    };

    config();
    virtual ~config();

    int get_key( int player, key_id key );
    void set_key( int player, key_id key, int value );

    string& get_name( int player ) throw ( string ) {
      if ( player >= 0 && player < MAX_LOCAL_PLAYERS )
        return ( player_names[player] );
      else
        throw ( "config::get_name(): Invalid player" );
    }
    void set_name( int player, const string& name )
    { if ( player >= 0 && player < MAX_LOCAL_PLAYERS ) player_names[player] = name; }

    string& get_server()
    { return ( server ); }
    void set_server( const string& serv )
    { server = serv; }

    string& get_port()
    { return ( port ); }
    void set_port( const string& n )
    { port = n; }


    const char  *key_to_str( int key ) throw ( int );
    int         str_to_key( const char *str );
    int         str_to_key_default( const char *str, int defkey ) {
      int   n = str_to_key( str );
      return ( ( n > 0 ) ? n : defkey );
    }

    static const char   *keystrings[];
    static const char   *DEFAULT_NAMES[MAX_LOCAL_PLAYERS];
    static const char   *DEFAULT_SERVER;
    static const char   *DEFAULT_PORT;

  protected:
    int     keymap[MAX_LOCAL_PLAYERS][_NUM_KEYS];
    string	player_names[MAX_LOCAL_PLAYERS];
    string	server;
    string	port;
};

class file_config : public config
{
  public:
    file_config( config *cfg = NULL );
    virtual ~file_config();

    virtual string get_config_fn();

    virtual void read_config( string& fn ) throw ( string );
    virtual void write_config( string& fn ) throw ( string );

  protected:
    virtual void write_string( FILE *fp, const char *key, const char *value ) throw ( string );
    virtual void write_int( FILE *fp, const char *key, int value ) throw ( string );
    string    configfile;
};


#endif /* CONFIG_H_INCLUDED */
