/*
  Copyright (C) 2004-2005 Tommi Tervonen, Petteri Klemola, Pasi Orovuo, Marko Mattila

  This file is part of Kajaani Kombat.

  Kajaani Kombat is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  Kajaani Kombat is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with Kajaani Kombat; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "game_statistic.h"


player_statistic::player_statistic(int owner_id){
  id		= owner_id;
  nr_hits	= 0;
  nr_all_shots	= 0;
  nr_cannon_hits = 0;
  nr_destroyed_cannons = 0;
}

player_statistic::player_statistic(const player_statistic &ps){
  id		= ps.id;
  nr_hits	= ps.nr_hits;
  nr_all_shots	= ps.nr_all_shots;
  nr_cannon_hits = ps.nr_cannon_hits;
  nr_destroyed_cannons = ps.nr_destroyed_cannons;
}

player_statistic::~player_statistic(){

}

 bool player_statistic::operator < (const player_statistic *ps){
  if (this->get_hit_percent() < ps->get_hit_percent())
    return true; 
  else
    return false;
}

int player_statistic::get_id(){
  return id;
}


double player_statistic::get_hit_percent() const{
  if (nr_all_shots == 0) return 0.0;
  return ((double)nr_hits)/nr_all_shots * 100.0;
}
double player_statistic::get_ricochet_percent() const{
  if (nr_all_shots == 0) return 0.0;
  return ((double)(nr_all_shots-nr_hits))/nr_all_shots * 100.0;
}
int player_statistic::get_hits() {
  return nr_hits;
}
int player_statistic::get_all_shots() {
  return nr_all_shots;
}
int player_statistic::get_ricochets() {
  return nr_all_shots - nr_hits;
}
int player_statistic::get_cannon_hits(){
	return nr_cannon_hits;
}	
int player_statistic::get_destroyed_cannons(){
	return nr_destroyed_cannons;
}

/* ------------ class game_statistic ------------- */

game_statistic::game_statistic(){
  p_stats = new vector<player_statistic*>(0);
}

game_statistic::~game_statistic(){
  for (unsigned int i=0;i<p_stats->size();i++){
    if (p_stats->at(i))
      delete p_stats->at(i);
  }
  delete p_stats;
}


bool game_statistic::add_player(player_statistic *ps){
  unsigned int sz_p_stats;

  if (get_player_by_id(ps->get_id()) != NULL)
    return false; // player with id exists already
  

  sz_p_stats = p_stats->size();
  p_stats->push_back(ps);
  if (sz_p_stats >= p_stats->size())
    return false;
  else
    return true;
  
}

bool game_statistic::update_player_nr_hits(int id, int hits){
  player_statistic *ps = get_player_by_id(id);
  if (ps){
    ps->nr_hits += hits;
    return true;
  }
  else
    return false;
}

bool game_statistic::update_player_nr_cannon_hits(int id, int hits) {
  player_statistic *ps = get_player_by_id(id);
  if (ps){
    ps->nr_cannon_hits += hits;
    return true;
  }
  else
    return false;
}

bool game_statistic::update_player_nr_destroyed_cannons(int id){
  player_statistic *ps = get_player_by_id(id);
  if (ps){
    ++ps->nr_destroyed_cannons;
    return true;
  }
  else
    return false;  
}
bool game_statistic::update_player_nr_all_shots(int id, int shots){
  player_statistic *ps = get_player_by_id(id);
  if (ps){
    ps->nr_all_shots += shots;
    return true;
  }
  else
    return false;
}

player_statistic *game_statistic::get_player_by_id(int id){
  for (unsigned int i=0;i<p_stats->size();i++){
    if (p_stats->at(i)->get_id() == id)
      return p_stats->at(i); 
  }
  return NULL;
}

/**
 **	Return the player with the best hit accuracy.
 **
 **/
player_statistic *game_statistic::get_best_player(){
  double res = 0;
  int ix = -1;

  for (unsigned int i=0;i<p_stats->size();i++){
    double tmp = p_stats->at(i)->get_hit_percent();
    if (tmp > res){
      res = tmp;
      ix = i; 
    }
  }
  
  return p_stats->at(ix);
}

/**
 ** Return the player with worst hit percent (biggest miss percent).
 **/
player_statistic *game_statistic::get_worst_player(){
  double res = 0;
  int ix = -1;

  for (unsigned int i=0;i<p_stats->size();i++){
    double tmp = p_stats->at(i)->get_ricochet_percent();    
    if (tmp > res){
      res = tmp;
      ix = i; 
    }
  }
  fprintf(stdout, "index: %d\n",ix);
  return p_stats->at(ix);
}


void game_statistic::remove_player(int id){
  vector<player_statistic*>::iterator it;
  player_statistic *tmp = NULL;
  for (it=p_stats->begin();it != p_stats->end();it++)
    {
      player_statistic * ps = *it;
      if (ps)
	if (id == ps->get_id()){
	  tmp = *it;
	  p_stats->erase(it);
	  break;
	}
    }
    delete tmp;

}


vector<player_statistic*> * game_statistic::get_statistics(){
	/*
	vector <player_statistic*> res = new vector<player_statistic*>();
	vector <int> indx();
	
	int n_indeces = p_stats->size();
	int index=0;
	double last_value = 0;
	
	for (int i=0;i<p_stats->size();i++){
		last_value = p_stats->at(i)->get_hit_percent();
		index = i;
		for (int j=i+1;i<p_stats->size();j++){
			
			if (last_value <= p_stats->at(j)->get_hit_percent()){
				int add = 0;
				
				for (int k=0;k<res->size();k++){
					// Check if this index already exist in res
					
				}
				
				if(add){
					indx.push_back(j);
					last_value = p_stats->at(j)->get_hit_percent();
					index = j;
				}
			}
		}
		--n_indeces;
		res->push_back(p_stats->at(j));
	}
	*/
	
	
  return p_stats;
}

void game_statistic::reinit()
{
  for (unsigned int i=0;i<p_stats->size();i++)
    p_stats->at(i)->reinit();
}

void player_statistic::reinit()
{
  nr_hits = 0;
  nr_all_shots = 0;
  nr_cannon_hits = 0;
  nr_destroyed_cannons = 0;
}
