/**
 * @file common_ui.h
 * @brief Shared UI utilities and layout helpers.
 *
 * Contains reusable functions for drawing text, handling resizing,
 * and rendering shared UI components across multiple screens.
 */

#ifndef COMMON_UI_H
#define COMMON_UI_H

#include "common/appstate.h"

#include <stdbool.h>

void setRGB(PixelData p);
void setAlbumColor(PixelData color);
void incrementUpdateCounter(void);
void inverseText(void);
void applyColor(ColorMode mode, ColorValue themeColor, PixelData albumColor);
void processNameScroll(const char *name, char *output, int maxWidth, bool isSameNameAsLastTime);
void resetNameScroll(void);
void resetColor(void);
void processName(const char *name, char *output, int maxWidth, bool stripUnneededChars, bool stripSuffix);
void transferSettingsToUI(void);
void enableMouse(UISettings *ui);
int getUpdateCounter(void);
bool getIsLongName(void);
PixelData increaseLuminosity(PixelData pixel, int amount);
PixelData decreaseLuminosityPct(PixelData base, float pct);
PixelData getGradientColor(PixelData baseColor, int row, int maxListSize, int startGradient, float minPct);

#endif
