/*
 * Copyright (c) 2018 SimK
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef	IA32_CPU_INSTRUCTION_MMX_AMD3DNOW_H__
#define	IA32_CPU_INSTRUCTION_MMX_AMD3DNOW_H__

#ifdef __cplusplus
extern "C" {
#endif

enum{
	AMD3DNOW_SUFFIX_PAVGUSB	= 0xBF,
	AMD3DNOW_SUFFIX_PFADD	= 0x9E,
	AMD3DNOW_SUFFIX_PFSUB	= 0x9A,
	AMD3DNOW_SUFFIX_PFSUBR	= 0xAA,
	AMD3DNOW_SUFFIX_PFACC	= 0xAE,
	AMD3DNOW_SUFFIX_PFCMPGE	= 0x90,
	AMD3DNOW_SUFFIX_PFCMPGT	= 0xA0,
	AMD3DNOW_SUFFIX_PFCMPEQ	= 0xB0,
	AMD3DNOW_SUFFIX_PFMIN	= 0x94,
	AMD3DNOW_SUFFIX_PFMAX	= 0xA4,
	AMD3DNOW_SUFFIX_PI2FD	= 0x0D,
	AMD3DNOW_SUFFIX_PF2ID	= 0x1D,
	AMD3DNOW_SUFFIX_PFRCP	= 0x96,
	AMD3DNOW_SUFFIX_PFRSQRT	= 0x97,
	AMD3DNOW_SUFFIX_PFMUL	= 0xB4,
	AMD3DNOW_SUFFIX_PFRCPIT1 = 0xA6,
	AMD3DNOW_SUFFIX_PFRSQIT1 = 0xA7,
	AMD3DNOW_SUFFIX_PFRCPIT2 = 0xB6,
	AMD3DNOW_SUFFIX_PMULHRW = 0xB7,
	AMD3DNOW_SUFFIX_PF2IW = 0x1C,
	AMD3DNOW_SUFFIX_PI2FW = 0x0C,
	AMD3DNOW_SUFFIX_PFNACC = 0x8A,
	AMD3DNOW_SUFFIX_PFPNACC = 0x8E,
	AMD3DNOW_SUFFIX_PSWAPD = 0xBB,
};
	
void AMD3DNOW_F0(void);

void AMD3DNOW_FEMMS(void);

void AMD3DNOW_PREFETCH(void);

#ifdef __cplusplus
}
#endif

#endif	/* IA32_CPU_INSTRUCTION_MMX_AMD3DNOW_H__ */
