/* matchbox-nest - a graphical wrapper around xnest
 *
 *  Copyright 2004 Matthew Allum
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 */

#include "fakedev.h"

FakeButton*
button_new(FakeApp *app, 
	   int      x, 
	   int      y, 
	   int      width, 
	   int      height, 
	   KeySym   ks,
	   int      repeat,
	   MBPixbufImage *img)
{
  FakeButton *button = malloc(sizeof(FakeButton));
  memset(button, 0, sizeof(FakeButton));

  button->x = x;
  button->y = y;
  button->height = height;
  button->width  = width;
  button->keysym = ks;
  button->img    = img;
  button->repeat = repeat;

  if (button->img)
    {
      if (mb_pixbuf_img_get_width(button->img) != button->width
	  || mb_pixbuf_img_get_height(button->img) != button->height)
	{
	  fprintf(stderr, 
		  "** warning: Button image size does not equal defined button size.\n"
		  );

	}
    }

  /* keysyms */

  return button;
}


FakeButton*
button_find_from_win(FakeApp *app, Window xevent_window_id)
{
  FakeButton *button;

  for (button = app->button_head; button; button=button->next) 
    if (button->win == xevent_window_id)
      return button;

  return NULL;

} 

void
button_press(FakeApp *app, FakeButton *button)
{
  keys_send_key(app, button->keysym, KEYDOWN);

  XSetWindowBackgroundPixmap(app->dpy, button->win, button->backing_active);  
  XClearWindow(app->dpy, button->win);
}

void
button_release(FakeApp *app, FakeButton *button)
{
  keys_send_key(app, button->keysym, KEYUP);

  XSetWindowBackgroundPixmap(app->dpy, button->win, button->backing);
  XClearWindow(app->dpy, button->win);
}

void
button_activate(FakeApp *app, FakeButton *button)
{
  ;
}
