/*-
 * Copyright (c) 2023 Jason R. Thorpe.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED
 * AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#ifndef listing_h_included
#define	listing_h_included

#include <stdbool.h>
#include <stdint.h>

#include "listing.h"
#include "nbsd_queue.h"

struct listing {
	char		*data;
	size_t		length;
	TAILQ_HEAD(, listing_category) categories;
	TAILQ_HEAD(, listing_entry) entries;
	unsigned int	next_fileno;
	unsigned int	longest_name;
};

struct listing_category {
	TAILQ_ENTRY(listing_category) link;
	const char	*name;
	TAILQ_HEAD(, listing_entry) entries;
};

struct listing_entry {
	TAILQ_ENTRY(listing_entry) category_link;
	TAILQ_ENTRY(listing_entry) listing_link;
	const char	*name;
	const char	*desc;
	unsigned int	number;
};

struct listing_entry *listing_entry_lookup(struct listing *, unsigned int);
struct listing	*listing_create(char *, size_t);
void		listing_free(struct listing *);

#endif /* listing_h_included */
