//
// nono
// Copyright (C) 2023 nono project
// Licensed under nono-license.txt
//

//
// DAA のテスト
//

#include "optestxp_subr.h"

static void
gentest_daa()
{
	init("daa", "testrun1");

	out("testexec_%s:\n", testname);
	out("	DAA\n");
	out("	RET\n");

	out_testset();

	for (int nin = 0; nin <= 1; nin++) {
		for (uint32 dst = 0; dst < 0x100; dst++) {
			for (int hin = 0; hin <= 1; hin++) {
				for (int cin = 0; cin <= 1; cin++) {
					uint32 ah = dst >> 4;
					uint32 al = dst & 0x0f;
					uint32 add = 0;
					bool c = false;

					if (nin == 0) {
						if (cin == 0) {
							if (hin == 0) {
								if (ah < 9) {
									if (al < 10) {
									} else {
										add = 0x06;
									}
								} else if (ah == 9) {
									if (al < 10) {
									} else {
										add = 0x66;
										c = true;
									}
								} else {
									if (al < 10) {
										add = 0x60;
									} else {
										add = 0x66;
									}
									c = true;
								}
							} else {	// H=1
								if (ah < 9) {
									add = 0x06;
								} else if (ah == 9) {
									if (1 || al < 10) {	// HD64180?
										add = 0x06;
									} else {
										add = 0x66;
										c = true;
									}
								} else {
									add = 0x66;
									c = true;
								}
							}
						} else {	// C=1
							if (hin == 0) {
								if (al < 10) {
									add = 0x60;
								} else {
									add = 0x66;
								}
							} else {
								add = 0x66;
							}
							c = true;
						}
					} else {	// N=1
						if (cin == 0) {
							if (hin == 0) {
							} else {	// H=1
								add = 0x06;
								if (dst < 6) {
									c = true;
								}
							}
						} else {	// C=1
							if (hin == 0) {
								add = 0x60;
							} else {
								add = 0x66;
							}
							c = true;
						}
					}

					uint32 res32;
					if (nin == 0) {
						res32 = dst + add;
					} else {
						res32 = dst - add;
					}
					uint8 res = res32;

					hd64180flag inflag;
					inflag.N = nin;
					inflag.H = hin;
					inflag.C = cin;

					hd64180flag flag;
					flag.Z = (res == 0);
					flag.S = ((res & 0x80) != 0);
					flag.C = c;
					flag.PV = pflag(res);
					flag.H = (nin == 0) ?
						hflag_add(dst, add) : hflag_sub(dst, add);
					flag.N = nin;
					out_testdata_run1(dst, inflag, res, flag);
				}
			}
		}
	}
	out("	defb	0,0,0,0FFH\n");
	out("\n");
}

int
main(int ac, char *av[])
{
	out("	org	0100H\n");
	gentest_daa();
	out("	RET\n");

	return 0;
}
