//
// nono
// Copyright (C) 2020 nono project
// Licensed under nono-license.txt
//

#pragma once

class m680x0ACC : public m680x0CCR
{
 public:
	// res を元に NZVC フラグをセットする。
	// res の上位ビットは無視される。
	inline void move_8(uint32 res) {
		Z = res << 24;
		N = Z;
		C = 0;
		V = 0;
	}

	// res を元に NZVC フラグをセットする。
	// res の上位ビットは無視される。
	inline void move_16(uint32 res) {
		Z = res << 16;
		N = Z;
		C = 0;
		V = 0;
	}

	// res を元に NZVC フラグをセットする。
	inline void move_32(uint32 res) {
		Z = res;
		N = res;
		C = 0;
		V = 0;
	}

	uint32 add_8(uint32, uint32);
	uint32 add_16(uint32, uint32);
	uint32 add_32(uint32, uint32);
	uint32 addx_8(uint32, uint32);
	uint32 addx_16(uint32, uint32);
	uint32 addx_32(uint32, uint32);
	uint32 cmp_8(uint32, uint32);
	uint32 cmp_16(uint32, uint32);
	uint32 cmp_32(uint32, uint32);
	uint32 sub_8(uint32, uint32);
	uint32 sub_16(uint32, uint32);
	uint32 sub_32(uint32, uint32);
	uint32 subx_8(uint32, uint32);
	uint32 subx_16(uint32, uint32);
	uint32 subx_32(uint32, uint32);
	uint32 mulu_16(uint32, uint32);
	uint32 muls_16(uint32, uint32);
	uint32 mulu_32(uint32, uint32);
	uint32 muls_32(uint32, uint32);
	uint64 mulu_64(uint32, uint32);
	uint64 muls_64(uint32, uint32);
	void   btst(uint32, int);
	uint32 bchg(uint32, int);
	uint32 bclr(uint32, int);
	uint32 bset(uint32, int);
	uint32 asl_8(uint32, int);
	uint32 asl_16(uint32, int);
	uint32 asl_32(uint32, int);
	uint32 lsl_8(uint32, int);
	uint32 lsl_16(uint32, int);
	uint32 lsl_32(uint32, int);
	uint32 roxl_8(uint32, int);
	uint32 roxl_16(uint32, int);
	uint32 roxl_32(uint32, int);
	uint32 rol_8(uint32, int);
	uint32 rol_16(uint32, int);
	uint32 rol_32(uint32, int);
	uint32 asr_8(uint32, int);
	uint32 asr_16(uint32, int);
	uint32 asr_32(uint32, int);
	uint32 lsr_8(uint32, int);
	uint32 lsr_16(uint32, int);
	uint32 lsr_32(uint32, int);
	uint32 roxr_8(uint32, int);
	uint32 roxr_16(uint32, int);
	uint32 roxr_32(uint32, int);
	uint32 ror_8(uint32, int);
	uint32 ror_16(uint32, int);
	uint32 ror_32(uint32, int);

	void chk2cmp2_32(uint32, uint32, uint32);
	uint32 abcd_8(uint32 src ,uint32 dst);
	uint32 sbcd_8(uint32 src, uint32 dst);

 private:
	static inline uint32 vflag_add_8(uint32 src, uint32 dst, uint32 res);
	static inline uint32 vflag_add_16(uint32 src, uint32 dst, uint32 res);
	static inline uint32 vflag_add_32(uint32 src, uint32 dst, uint32 res);
	static inline uint32 vflag_sub_8(uint32 src, uint32 dst, uint32 res);
	static inline uint32 vflag_sub_16(uint32 src, uint32 dst, uint32 res);
	static inline uint32 vflag_sub_32(uint32 src, uint32 dst, uint32 res);
};
