//
// nono
// Copyright (C) 2024 nono project
// Licensed under nono-license.txt
//

//
// VirtIO SCSI デバイス
//

#pragma once

#include "virtio_base.h"
#include <array>

class SCSIDomain;
class SCSIHostDevice;

class VirtIOSCSIDevice : public VirtIODevice
{
	using inherited = VirtIODevice;
 public:
	VirtIOSCSIDevice(uint slot_);
	~VirtIOSCSIDevice() override;

	bool Create() override;
	bool Init() override;
	void ResetHard(bool poweron) override;

	SCSIDomain *GetDomain() const noexcept { return domain.get(); }

	// アクセス状況を返す
	void GetAccess(std::array<uint32, 16> *dst) const { *dst = access; }

 private:
	DECLARE_MONITOR_CALLBACK(MonitorUpdate);

	void ProcessDesc(VirtIOReq&) override;

	void ProcessDescControl(VirtIOReq&);
	void ProcessDescEvent(VirtIOReq&);
	void ProcessDescRequest(VirtIOReq&);
	void ProcessDescRequestError(VirtIOReq&, uint32 response, uint32 residual);

	const char *GetFeatureName(uint feature) const override;

	// SCSI 管理
	std::unique_ptr<SCSIDomain> domain /*{}*/;

	// SCSI ホスト
	SCSIHostDevice *host {};

	uint32 sense_size {};
	uint32 cdb_size {};

	// アクセスインジケータ用。
	// [0] が ID0 の read 用、[1] が ID0 の write 用、
	// [2] が ID1 の read 用、[3] が ID1 の write 用、
	// …の要領で並べてある。
	std::array<uint32, 8 * 2> access {};
};
