//
// nono
// Copyright (C) 2020 nono project
// Licensed under nono-license.txt
//

//
// ログモニター
//

#pragma once

#include "wxsubwindow.h"
#include "wxscrollbar.h"
#include "wxmonitor.h"

class Logger;
class WXLogMonitor;

// モニター部分
class LogMonitorPanel : public WXMonitorPanel
{
	using inherited = WXMonitorPanel;
 public:
	LogMonitorPanel(WXLogMonitor *parent_, Monitor *monitor_);
	~LogMonitorPanel() override;

	void DoRefresh() override;

 private:
	WXLogMonitor *parent {};
};

// ログウィンドウ
class WXLogMonitor : public WXSubWindow
{
	using inherited = WXSubWindow;
	friend class LogMonitor;

 public:
	explicit WXLogMonitor(wxWindow *);
	~WXLogMonitor() override;

	void FontChanged() override;
	bool Layout() override;

	// スクロールバー再設定
	void SetScroll();

 private:
	bool GetMySizeHints(wxSize *, wxSize *, wxSize *, wxSize *) override;

	// マウスホイールイベント
	void OnMouseWheel(wxMouseEvent&);

	// スクロールイベント
	void OnScroll(wxScrollEvent&);

	// スクロール処理
	void DoScroll(int pos);

	LogMonitorPanel *screen {};

	// スクロールバー
	WXScrollBar *vscroll {};

	Logger *logger {};
};
