//
// nono
// Copyright (C) 2022 nono project
// Licensed under nono-license.txt
//

//
// パレットモニターウィンドウ
//

#pragma once

#include "wxtextpanel.h"
#include "wxsubwindow.h"
#include "color.h"

class BT45xDevice;
class VideoCtlrDevice;

// パレットパネル
class WXPalettePanel : public WXTextPanel
{
	using inherited = WXTextPanel;
 public:
	explicit WXPalettePanel(wxWindow *parent);
	~WXPalettePanel() override;

	void FontChanged() override;
	void Draw() override;

 private:
	void PaletteChanged();
	void OnMouse(wxMouseEvent& event);
	void OnPaletteChanged(wxCommandEvent& event);

	// ホストパレット
	std::vector<Color> pal {};

	// ゲストパレット。
	std::vector<uint16> vcpal {};	// X68030 のパレットレジスタ
	std::vector<uint8> btpal {};	// Bt454/458 のパレット

	// パレット欄の行数
	int rows {};

	// パレット領域の開始オフセット [px]
	int pal0x {};
	int pal1x {};					// X68030 の右列
	int pal0y {};

	// パレット番号に必要な16進桁数。
	uint idxlen {};

	// 現在指しているパレット
	int cursor {};

	BT45xDevice *bt45x {};
	VideoCtlrDevice *videoctlr {};

	wxDECLARE_EVENT_TABLE();
};

// パレットウィンドウ
class WXPaletteWindow : public WXSubWindow
{
	using inherited = WXSubWindow;
 public:
	WXPaletteWindow(wxWindow *parent, const wxString& name);
	~WXPaletteWindow() override;
};
