//
// nono
// Copyright (C) 2022 nono project
// Licensed under nono-license.txt
//

//
// NWS-1750 のキーボードコントローラ(予定地)
//

// デバイスが存在しないことをバスエラーで検出できないので、
// とりあえず用意して生返事だけさせておく。

#include "kbc.h"

// コンストラクタ
KBCDevice::KBCDevice()
	: inherited(OBJ_KBC)
{
}

// デストラクタ
KBCDevice::~KBCDevice()
{
}

busdata
KBCDevice::ReadPort(uint32 offset)
{
	busdata data;

	switch (offset) {
	 case KEYDATA:
		data = 0;
		break;

	 case KEYSTAT:
		data = 0xc0;	// KBRDY, MSRDY
		break;

	 case KEYINTE:
		data = 0;		// ?
		break;

	 case KEYRESET:
		data = 0xff;	// ?
		break;

	 case KEYBUZZ:
		data = 0xff;	// ?
		break;

	 case MSDATA:
		data = 0;
		break;

	 case MSINTE:		// ?
		data = 0;
		break;

	 case MSRESET:		// ?
		data = 0xff;
		break;

	 default:
		data = 0xff;
		break;
	}

	data |= BusData::Size1;
	return data;
}

busdata
KBCDevice::WritePort(uint32 offset, uint32 data)
{
	// とりあえず全無視
	return BusData::Size1;
}

busdata
KBCDevice::PeekPort(uint32 offset)
{
	// XXX 未実装
	return 0xff;
}

bool
KBCDevice::PokePort(uint32 offset, uint32 data)
{
	return false;
}
