//
// nono
// Copyright (C) 2020 nono project
// Licensed under nono-license.txt
//

//
// テキストフォントを描画するパネル
//

// wxPanel
//  ↓
// WXTextPanel  テキストフォントを描画するパネル
//  ↓
// WXTextScreen テキストスクリーンを表示するパネル

#pragma once

#include "wxbitmappanel.h"
#include "textscreen.h"

class WXTextPanel : public WXBitmapPanel
{
	using inherited = WXBitmapPanel;

	// パレット番号
	static const int BG = 0;
	static const int FG = 1;

 public:
	WXTextPanel(wxWindow *parent, wxWindowID id = wxID_ANY,
		const wxPoint& position = wxDefaultPosition,
		const wxSize& size = wxDefaultSize,
		long style = wxTAB_TRAVERSAL);
	~WXTextPanel() override;

	// フォント変更通知
	virtual void FontChanged();

	int GetFontWidth() const { return font_width; }
	int GetFontHeight() const { return font_height; }

 protected:
	// テキスト色を指定
	void ResetTextColor();
	void SetTextColor(Color fg, Color bg);
	void SetTextForeColor(Color fg) { palette[FG] = fg; }
	void SetTextBackColor(Color bg) { palette[BG] = bg; }

	// テキスト色を取得
	Color GetTextForeColor() const { return palette[FG]; }
	Color GetTextBackColor() const { return palette[BG]; }

	// Shift_JIS (正確には CP932) 文字列を描画する。
	void DrawStringSJIS(Color c, int px, int py, const char *sjis,
		uint attr = TA::Normal);
	void DrawStringSJIS(int px, int py, const char *sjis,
		uint attr = TA::Normal);

	// 半角1文字を描画
	void DrawChar1(int px, int py, uint code, uint attr = TA::Normal);
	// 全角1文字を描画
	void DrawChar2(int px, int py, uint code, uint attr = TA::Normal);

	// フォントサイズ
	int font_width {};
	int font_height {};

	// 色
	Color palette[2] {};
};
