//
// nono
// Copyright (C) 2020 nono project
// Licensed under nono-license.txt
//

//
// 何もしないデバイス
//

#include "nop.h"

// コンストラクタ
NopIODevice::NopIODevice()
	: inherited(OBJ_NOPIO)
{
	ClearAlias();
	AddAlias("NopIO");
}

// デストラクタ
NopIODevice::~NopIODevice()
{
}

busdata
NopIODevice::Read(busaddr addr)
{
	uint32 datasize = addr.GetSize();

	putlog(1, "$%08x.%u", addr.Addr(), datasize);
	busdata data = (1ULL << (datasize * 8)) - 1;
	data |= busdata::Size(datasize);
	return data;
}

busdata
NopIODevice::Write(busaddr addr, uint32 data)
{
	uint32 datasize = addr.GetSize();

	putlog(1, "$%08x.%u <- $%0*x", addr.Addr(), datasize, datasize * 2, data);
	busdata r = busdata::Size(datasize);
	return r;
}

busdata
NopIODevice::Peek1(uint32 addr)
{
	return 0xff;
}

busdata
NopIODevice::Read1(uint32 addr)
{
	putlog(1, "XP $%05x", addr);
	busdata data = 0xff;
	return data;
}

busdata
NopIODevice::Write1(uint32 addr, uint32 data)
{
	putlog(1, "XP $%05x <- $%02x", addr, data);
	return 0;
}
