//
// nono
// Copyright (C) 2024 nono project
// Licensed under nono-license.txt
//

//
// VirtIO エントロピーデバイス
//

#pragma once

#include "virtio_base.h"
#include <random>

class VirtIOEntropyDevice : public VirtIODevice
{
	using inherited = VirtIODevice;

 public:
	explicit VirtIOEntropyDevice(uint slot_);
	~VirtIOEntropyDevice() override;

 private:
	DECLARE_MONITOR_SCREEN(MonitorScreen);

	// ディスクリプタを一つ処理する。
	void ProcessDesc(VirtIOReq&) override;

	// デフォルトコンストラクタは実質 /dev/urandom だが
	// こいつにはこれ以上安全な指定方法がない。
	std::random_device rnd {};
};
