//
// nono
// Copyright (C) 2022 nono project
// Licensed under nono-license.txt
//

//
// XP プロセッサの物理バス
//

#pragma once

#include "mainbus.h"
#include <array>

class NopIODevice;
class SubRAMDevice;
class SubRAM2Device;
class XPRAMDevice;

// XP 物理バス
class XPbusDevice : public IODevice
{
	using inherited = IODevice;
 public:
	XPbusDevice();
	~XPbusDevice() override;

	bool Init() override;
	void ResetHard(bool poweron) override;

	busdata Read1(uint32 addr) override;
	busdata Write1(uint32 addr, uint32 data) override;
	busdata Peek1(uint32 addr) override;
	bool Poke1(uint32 addr, uint32 data) override;

	// RAM Control Register (RMCR) を設定/取得
	uint32 GetRMCR() const;
	void SetRMCR(uint32);
	// 内蔵 RAM の先頭番地を取得 (モニタ用)
	uint32 GetXPRAMAddr() const { return ram_addr; }

 private:
	inline IODevice *SearchDevice(uint32 addr) const;

	// 3port RAM (非共有部)
	std::unique_ptr<SubRAM2Device> pSubRAM2 /*{}*/;
	// XP 内蔵 512 バイト RAM
	std::unique_ptr<XPRAMDevice> pXPRAM /*{}*/;

	// XP 内蔵 512 バイト RAM の位置
	uint32 ram_addr {};

	SubRAMDevice *subram {};	// 共有 SRAM
	NopIODevice *nopio {};
};

// XP 内蔵 RAM
class XPRAMDevice : public IODevice
{
	using inherited = IODevice;
 public:
	XPRAMDevice();
	~XPRAMDevice() override;

	busdata Read1(uint32 addr) override;
	busdata Write1(uint32 addr, uint32 data) override;
	busdata Peek1(uint32 addr) override;
	bool Poke1(uint32 addr, uint32 data) override;

 private:
	std::array<uint8, 512> ram {};
};

inline XPbusDevice *GetXPbusDevice() {
	return Object::GetObject<XPbusDevice>(OBJ_XPBUS);
}
