/*
 * Copyright (c) 2024-2025 Qualcomm Innovation Center, Inc. All rights reserved.
 * SPDX-License-Identifier: Apache-2.0
*/

#ifndef OPENCV_FASTCV_HPP
#define OPENCV_FASTCV_HPP

#include <opencv2/core.hpp>

#include "opencv2/fastcv/arithm.hpp"
#include "opencv2/fastcv/bilateralFilter.hpp"
#include "opencv2/fastcv/blur.hpp"
#include "opencv2/fastcv/channel.hpp"
#include "opencv2/fastcv/cluster.hpp"
#include "opencv2/fastcv/draw.hpp"
#include "opencv2/fastcv/edges.hpp"
#include "opencv2/fastcv/fast10.hpp"
#include "opencv2/fastcv/fft.hpp"
#include "opencv2/fastcv/histogram.hpp"
#include "opencv2/fastcv/hough.hpp"
#include "opencv2/fastcv/ipptransform.hpp"
#include "opencv2/fastcv/moments.hpp"
#include "opencv2/fastcv/mser.hpp"
#include "opencv2/fastcv/pyramid.hpp"
#include "opencv2/fastcv/remap.hpp"
#include "opencv2/fastcv/scale.hpp"
#include "opencv2/fastcv/shift.hpp"
#include "opencv2/fastcv/smooth.hpp"
#include "opencv2/fastcv/thresh.hpp"
#include "opencv2/fastcv/tracking.hpp"
#include "opencv2/fastcv/warp.hpp"
#include "opencv2/fastcv/allocator.hpp"
#include "opencv2/fastcv/dsp_init.hpp"
#include "opencv2/fastcv/sad_dsp.hpp"
#include "opencv2/fastcv/thresh_dsp.hpp"
#include "opencv2/fastcv/fft_dsp.hpp"
#include "opencv2/fastcv/edges_dsp.hpp"
#include "opencv2/fastcv/blur_dsp.hpp"
#include "opencv2/fastcv/color.hpp"

/**
 * @defgroup fastcv Module-wrapper for FastCV hardware accelerated functions
 * @{
 * @}
 */

#endif // OPENCV_FASTCV_HPP
