/* atom.c
 * Copyright (C) 2001 QT4Linux and OpenQuicktime Teams
 *
 * This file is part of OpenQuicktime, a free QuickTime library.
 *
 * Based on QT4Linux by Adam Williams.
 *
 * OpenQuicktime is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation.
 *
 * OpenQuicktime is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <ctype.h>
#include <stdio.h>
#include "funcprotos.h"
#include "openquicktime.h"





int quicktime_atom_reset(quicktime_atom_t *atom)
{
	atom->end = 0;
	atom->type[0] = atom->type[1] = atom->type[2] = atom->type[3] = 0;
	return 0;
}

int quicktime_atom_read_header(quicktime_t *file, quicktime_atom_t *atom)
{
	char header[10];
	int result;
	longest size2;

	quicktime_atom_reset(atom);

	atom->start = quicktime_position(file);

	if(!file->quicktime_read_data(file, header, HEADER_LENGTH)) return 1;
	result = quicktime_atom_read_type(header, atom->type);
	atom->size = quicktime_atom_read_size(header);
	atom->end = atom->start + atom->size;

	//  printf("quicktime_atom_read_header 1 %c%c%c%c start 0x%llx size %lld end 0x%llx ftell 0x%llx 0x%llx\n", 
	// 	atom->type[0], atom->type[1], atom->type[2], atom->type[3],
	//  	atom->start, atom->size, atom->end,
	//  	file->file_position,
	//  	(longest)FTELL(file->stream));
	

/* Skip placeholder atom */
	if(quicktime_match_32(atom->type, "wide"))
	{
		atom->start = quicktime_position(file);
		quicktime_atom_reset(atom);
		if(!file->quicktime_read_data(file, header, HEADER_LENGTH)) return 1;
		result = quicktime_atom_read_type(header, atom->type);
		atom->size -= 8;
		if(atom->size <= 0)
		{
/* Wrapper ended.  Get new atom size */
			atom->size = quicktime_atom_read_size(header);
		}
		atom->end = atom->start + atom->size;
	}
	else
/* Get extended size */
	if(atom->size == 1)
	{
		if(!file->quicktime_read_data(file, header, HEADER_LENGTH)) return 1;
		atom->size = quicktime_atom_read_size64(header);
		atom->end = atom->start + atom->size;
/*
 * printf("quicktime_atom_read_header 2 %c%c%c%c start 0x%llx size %lld end 0x%llx ftell 0x%llx\n", 
 * 	atom->type[0], atom->type[1], atom->type[2], atom->type[3],
 * 	atom->start, atom->size, atom->end,
 * 	file->file_position);
 */
	}


	return result;
}

int quicktime_atom_write_header64(quicktime_t *file, quicktime_atom_t *atom, char *text)
{
	int result = 0;
	atom->start = quicktime_position(file);

	result = !quicktime_write_int32(file, 1);
	if(!result) result = !quicktime_write_char32(file, text);
	if(!result) result = !quicktime_write_int64(file, 0);

	atom->use_64 = 1;
	return result;
}

int quicktime_atom_write_header(quicktime_t *file, quicktime_atom_t *atom, char *text)
{
	int result = 0;
	atom->start = quicktime_position(file);
	result = !quicktime_write_int32(file, 0);
	if(!result) result = !quicktime_write_char32(file, text);
	atom->use_64 = 0;
	return result;
}

void quicktime_atom_write_footer(quicktime_t *file, quicktime_atom_t *atom)
{
	atom->end = quicktime_position(file);
	if(atom->use_64)
	{
		quicktime_set_position(file, atom->start + 8);
//printf("quicktime_atom_write_footer 0x%llx 0x%llx 0x%llx 0x%llx\n", file->total_length, file->file_position, atom->start, atom->end);
		quicktime_write_int64(file, atom->end - atom->start);
	}
	else
	{
		quicktime_set_position(file, atom->start);
		quicktime_write_int32(file, atom->end - atom->start);
	}
	
	quicktime_set_position(file, atom->end);
}

int quicktime_atom_is(quicktime_atom_t *atom, char *type)
{
	if(atom->type[0] == type[0] &&
		atom->type[1] == type[1] &&
		atom->type[2] == type[2] &&
		atom->type[3] == type[3])
	return 1;
	else
	return 0;
}

unsigned long quicktime_atom_read_size(char *data)
{
	unsigned long result;
	unsigned long a, b, c, d;
	
	a = (unsigned char)data[0];
	b = (unsigned char)data[1];
	c = (unsigned char)data[2];
	d = (unsigned char)data[3];

	result = (a << 24) | (b << 16) | (c << 8) | d;

// extended header is size 1
//	if(result < HEADER_LENGTH) result = HEADER_LENGTH;
	return result;
}

longest quicktime_atom_read_size64(char *data)
{
	ulongest result, a, b, c, d, e, f, g, h;

	a = (unsigned char)data[0];
	b = (unsigned char)data[1];
	c = (unsigned char)data[2];
	d = (unsigned char)data[3];
	e = (unsigned char)data[4];
	f = (unsigned char)data[5];
	g = (unsigned char)data[6];
	h = (unsigned char)data[7];

	result = (a << 56) | 
		(b << 48) | 
		(c << 40) | 
		(d << 32) | 
		(e << 24) | 
		(f << 16) | 
		(g << 8) | 
		h;

	if(result < HEADER_LENGTH) result = HEADER_LENGTH;
	return (longest)result;
}

int quicktime_atom_read_type(char *data, char *type)
{
	type[0] = data[4];
	type[1] = data[5];
	type[2] = data[6];
	type[3] = data[7];

	//printf("%c%c%c%c ", type[0], type[1], type[2], type[3]); 
/* need this for quicktime_check_sig */
	if(isalpha(type[0]) && isalpha(type[1]) && isalpha(type[2]) && isalpha(type[3]))
	return 0;
	else
	return 1;
}

int quicktime_atom_skip(quicktime_t *file, quicktime_atom_t *atom)
{
	if(atom->start == atom->end) atom->end++;
	return quicktime_set_position(file, atom->end);
}
